$(document).ready(function () {

    //Agregar user
    $('.codi_add_usuario').on('submit', codi_add_usuario);
    function codi_add_usuario(event) {
        event.preventDefault();

        var form = $('.codi_add_usuario'),
            hook = 'codi_hook',
            action = 'add',
            data = new FormData(form.get(0)),
            Usuario = $('#Usuario').val(),
            Correo = $('#Correo').val(),
            Departamento = $('#Departamento').val(),
            NombreUsuario = $('#NombreUsuario').val(),
            Telefono = $('#Telefono').val(),
            Contra = $('#Contra').val();
        data.append('hook', hook);
        data.append('action', action);

        //validar que este seleccionado una opcion Usuario
        if (Usuario === '' || Correo === '' || Contra === '') {
            Swal.fire({
                icon: 'error',
                title: 'El nombre de usuario, correo o contraseña no pueden estar vacio',
                showConfirmButton: false,
                timer: 1500
            })

            return
        }
        //validar que este seleccionado una opcion Departamento
        if (Departamento === 'none') {
            Swal.fire({
                icon: 'error',
                title: 'El Departamento del usuario no puede estar vacio',
                showConfirmButton: false,
                timer: 1500
            })

            return
        }

        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_add_usuario',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 201) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                window.location.href = "";
                form.trigger('reset');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });


    }
    //Obtener Moviemientos
    codi_get_usuarios();
    function codi_get_usuarios() {
        var wrapper = $('.tabla_wrapper_usuarios'),
            hook = 'codi_hook',
            action = 'load';


        // AJAX Usuarios Get
        $.ajax({
            url: 'ajax/codi_get_usuarios',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {

            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
                $('.datatable-init').DataTable({
                    responsive: true,
                    orderCellsTop: true,
                    fixedHeader: true,
                    dom: 'Blfrtip',
                    buttons: ['copy', 'excel', 'csv', 'pdf'],
                    language: {
                        url: 'https://cdn.datatables.net/plug-ins/1.10.24/i18n/Spanish.json'
                    }
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion' + err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {

            });

    }

    $('#editForm').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('idusu');
        var Usuario = button.data('usuario');
        var NombreUsuario = button.data('nombreusuario');
        var Correo = button.data('correo');
        var Telefono = button.data('telefono');
        var Departamento = button.data('departamento');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#IdUsuE').val(id)
        modal.find('#EUsuario').val(Usuario)
        modal.find('#ECorreo').val(Correo)
        modal.find('#ETelefono').val(Telefono)
        modal.find('#EDepartamento').val(Departamento)
        modal.find('#ENombreUsuario').val(NombreUsuario)
    })

    //Obtener Moviemiento
    function codi_get_usuario() {

    }
    //Actualizar Moviemiento
    $('.codi_update_usuario').on('submit', codi_update_usuario);
    function codi_update_usuario(event) {
        event.preventDefault();

        var form = $('.codi_update_usuario'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData(form.get(0));
        console.log(data)

        data.append('hook', hook);
        data.append('action', action);
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_update_usuario',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                window.location.href = "";
                form.trigger('reset');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

    $('#modalAlert2').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('idusu');
        var usu = button.data('nombre');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#idUsuario').val(id)
        modal.find('#EUsuario').text(usu)
    })


    //Eliminar Moviemiento
    $('.codi_delete_usuario').on('click', codi_delete_usuario);
    function codi_delete_usuario(event) {
        event.preventDefault();
        var idUsuario = $('#idUsuario').val()
        console.log(idUsuario)
        var form = $('.codi_delete_usuario'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('activo', 400);
        data.append('idUsuario', idUsuario)
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: 'ajax/codi_delete_usuario',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }


    $(document).ready(function () {
        codi_get_departamento_select();
        function codi_get_departamento_select() {
            var wrapper = $('.select_wrapper_departamento'),
                hook = 'codi_hook',
                action = 'load';
            const w = document.querySelectorAll('.select_wrapper_departamento');

            $.ajax({
                url: 'ajax/codi_get_departamento_select',
                type: 'POST',
                dataType: 'json',
                cache: false,
                data: { hook, action },
                beforeSend: function () {
    
                }
            }).done(function (res) {
                if (res.status === 200) {
                    w.forEach(element => {
                        element.innerHTML = res.data
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Hubo un error en la peticion',
                        showConfirmButton: false,
                        timer: 1500
                    })
                    wrapper.html('');
    
                }
            })
                .fail(function (err) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Hubo un error en la peticion' + err,
                        showConfirmButton: false,
                        timer: 1500
                    })
                    wrapper.html('');
                })
                .always(function () {
    
                });
    
        }
    })

})