/* ======================= reparto.js (ENDPOINTS FIJOS + SWEETALERT) ======================= */
(() => {
  const API_BASE = 'https://grupoxtinfire.com/admin/ajax/';
  const HOOK = 'codi_hook';
  const ACTION = 'load';
  const ROOT_ID = 'reparto-card-body';
  const $ = (s,c=document)=>c.querySelector(s);
  const $$ = (s,c=document)=>Array.from(c.querySelectorAll(s));
  const colorswal = (typeof colortema === 'function') ? colortema() : 'default';

  // ===== Helpers =====
  async function apiPost(fnName, params={}) {
    const body = new URLSearchParams({ hook: HOOK, action: ACTION, ...params });
    const r = await fetch(API_BASE + fnName, {
      method: 'POST',
      headers: { 'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8' },
      body
    });
    const j = await r.json();
    if (!r.ok || j.error) throw new Error(j.data || j.msg || 'API error');
    return j.data;
  }
  const swErr = (msg) => Swal.fire({ icon:'error', title:'Error', text:String(msg||'Ocurrió un error'), theme: colorswal });
  const swOk  = (title='Hecho', text='') => Swal.fire({ icon:'success', title, text, timer:1400, showConfirmButton:false, theme: colorswal });

  const money = new Intl.NumberFormat('es-MX',{style:'currency',currency:'MXN'});
  const fmt = n => money.format(Number(n||0));
  const theme = () => (document.documentElement.getAttribute('data-bs-theme') || 'light');

  // 1er día del mes anterior → hoy
  function prevMonthFirstToToday() {
    const now = new Date();
    const y = now.getFullYear(), m = now.getMonth();
    const firstPrev = new Date(m===0 ? y-1 : y, m===0 ? 11 : m-1, 1);
    const pad = v => String(v).padStart(2,'0');
    const d1 = `${firstPrev.getFullYear()}-${pad(firstPrev.getMonth()+1)}-${pad(firstPrev.getDate())}`;
    const d2 = `${now.getFullYear()}-${pad(now.getMonth()+1)}-${pad(now.getDate())}`;
    return { d1, d2 };
  }

  // Normalización fuerte de tipo de pago → etiqueta
  const clean = v => (v??'').toString().normalize('NFD').replace(/[\u0300-\u036f]/g,'').trim().toUpperCase();
  function canonPago(code, name) {
    const c = clean(code);
    const n = clean(name);

    if (c === '99') return 'Por definir';
    if (n.includes('POR DEFINIR') || n === 'SIN TIPODEPAGO' || n === 'SIN TIPO DE PAGO' || n==='SIN PAGO') return 'Por definir';

    if (c === '01' || n.includes('EFECTIVO')) return 'Efectivo';
    if (c === '03' || n.includes('TRANSFER')) return 'Transferencia';
    if (c === '04' || (n.includes('TARJETA') && n.includes('CREDIT'))) return 'Tarjeta Crédito';
    if (c === '28' || (n.includes('TARJETA') && n.includes('DEBIT')))  return 'Tarjeta Débito';
    if (c === '02' || n.includes('CHEQUE')) return 'Cheque';
    if (n.includes('CREDITO')) return 'Crédito';
    return (name || code || '—');
  }

  function buildDomicilio(r){
    if (r.Domicilio) return r.Domicilio;
    const parts = [r.EntCalle, r.EntNExt, r.EntNInt, r.EntColonia, r.EntCP, r.EntMunicipio, r.EntEstado]
      .map(x => (x??'').toString().trim()).filter(Boolean);
    return parts.join(' ');
  }

  // ===== Estado =====
  let state = {
    pendientes: [],
    asignadas: [],
    reps14: [],
    reps22: [],
    pagePend: 1,
    pageAsig: 1,
    sizePend: 10,
    sizeAsig: 10,
    termPend: '',
    termAsig: ''
  };

  // ===== UI =====
  function buildUI(root){
    const range = prevMonthFirstToToday();
    root.innerHTML = `
      <div class="card mb-3">
        <div class="card-body d-flex flex-wrap gap-2 align-items-end">
          <div class="btn-group" role="group">
            <button id="tab-pend" class="btn btn-danger text-white">Pendientes (16/21)</button>
            <button id="tab-asig" class="btn btn-outline-danger">Asignadas (14/22)</button>
          </div>
          <div class="ms-auto d-flex gap-2">
            <input id="fini" type="date" class="form-control" style="max-width:180px">
            <input id="ffin" type="date" class="form-control" style="max-width:180px">
            <button id="btn-buscar" class="btn btn-dark">Buscar</button>
          </div>
        </div>
      </div>

      <div id="view-pend" class="card">
        <div class="card-body">
          <div class="d-flex flex-wrap justify-content-between gap-2 mb-2">
            <input id="srch-pend" type="search" class="form-control form-control-sm" placeholder="Buscar orden/cliente/domicilio…" style="max-width:320px">
            <div>
              <label class="me-2 small">Filas</label>
              <select id="size-pend" class="form-select form-select-sm" style="width:84px;">
                <option>10</option><option>25</option><option>50</option>
              </select>
            </div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead>
                <tr>
                  <th>Fecha</th><th>Orden</th><th>Cliente</th><th>Domicilio</th>
                  <th>Tipo pago</th><th>Estado</th>
                  <th>Depto destino</th><th>Repartidor</th><th>Acción</th>
                </tr>
              </thead>
              <tbody id="tb-pend"></tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small" id="info-pend"></div>
            <div id="pag-pend" class="btn-group"></div>
          </div>
        </div>
      </div>

      <div id="view-asig" class="card d-none">
        <div class="card-body">
          <div class="d-flex flex-wrap justify-content-between gap-2 mb-2">
            <input id="srch-asig" type="search" class="form-control form-control-sm" placeholder="Buscar orden/cliente/domicilio…" style="max-width:320px">
            <div>
              <label class="me-2 small">Filas</label>
              <select id="size-asig" class="form-select form-select-sm" style="width:84px;">
                <option>10</option><option>25</option><option>50</option>
              </select>
            </div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead>
                <tr>
                  <th>Fecha</th><th>Orden</th><th>Cliente</th><th>Domicilio</th>
                  <th>Repartidor</th><th>Depto</th>
                  <th>Estatus reparto</th><th>Acciones</th>
                </tr>
              </thead>
              <tbody id="tb-asig"></tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small" id="info-asig"></div>
            <div id="pag-asig" class="btn-group"></div>
          </div>
        </div>
      </div>
    `;
    $('#fini').value = range.d1;
    $('#ffin').value = range.d2;

    const setTab = (name)=>{
      const a = $('#tab-asig'), p = $('#tab-pend');
      if (name==='pend'){
        $('#view-pend').classList.remove('d-none');
        $('#view-asig').classList.add('d-none');
        p.className = 'btn btn-danger text-white';
        a.className = 'btn btn-outline-danger';
      } else {
        $('#view-asig').classList.remove('d-none');
        $('#view-pend').classList.add('d-none');
        a.className = 'btn btn-danger text-white';
        p.className = 'btn btn-outline-danger';
      }
    };

    $('#tab-pend').addEventListener('click', ()=>setTab('pend'));
    $('#tab-asig').addEventListener('click', ()=>setTab('asig'));
    $('#btn-buscar').addEventListener('click', async ()=>{
      state.pagePend=1;
      try { await loadPendientes(); } catch(e){ swErr(e.message); }
    });

    $('#srch-pend').addEventListener('input', (e)=>{ state.termPend = e.target.value.trim().toLowerCase(); state.pagePend=1; renderPendientes(); });
    $('#srch-asig').addEventListener('input', (e)=>{ state.termAsig = e.target.value.trim().toLowerCase(); state.pageAsig=1; renderAsignadas(); });
    $('#size-pend').addEventListener('change', (e)=>{ state.sizePend = parseInt(e.target.value,10)||10; state.pagePend=1; renderPendientes(); });
    $('#size-asig').addEventListener('change', (e)=>{ state.sizeAsig = parseInt(e.target.value,10)||10; state.pageAsig=1; renderAsignadas(); });
  }

  // ===== Filtro + paginación =====
  function filterRows(rows, term){
    if (!term) return rows;
    return rows.filter(r=>{
      const s = [
        r.IdOrden, r.FolioOrden, r.Cliente, r.Domicilio,
        r.PagoCanon, r.Repartidor
      ].map(v=> (v??'').toString().toLowerCase()).join(' ');
      return s.includes(term);
    });
  }

  function paginate(rows, page, size){
    const total = rows.length;
    const pages = Math.max(1, Math.ceil(total/size));
    const p = Math.min(Math.max(1,page), pages);
    const start = (p-1)*size;
    return { slice: rows.slice(start, start+size), page:p, pages, total };
  }

  function renderPager(container, page, pages, onJump){
    container.innerHTML = '';
    const mk = (txt, go, disabled=false, active=false)=>{
      const b = document.createElement('button');
      b.className = 'btn btn-sm ' + (active ? 'btn-danger text-white' : 'btn-outline-danger');
      b.disabled = !!disabled;
      b.textContent = txt;
      if (!disabled) b.onclick = ()=>onJump(go);
      container.appendChild(b);
    };
    mk('«', 1, page===1);
    mk('‹', page-1, page===1);
    for (let i=Math.max(1,page-2); i<=Math.min(pages,page+2); i++){
      mk(String(i), i, false, i===page);
    }
    mk('›', page+1, page===pages);
    mk('»', pages, page===pages);
  }

  function optReps(depto){
    const list = (depto==14) ? state.reps14 : state.reps22;
    return ['<option value="">— seleccionar —</option>']
      .concat(list.map(u=>`<option value="${u.IdUsuario}">${u.Usuario}</option>`))
      .join('');
  }

  // ===== Renders =====
  function renderPendientes(){
    const tb   = $('#tb-pend');
    const info = $('#info-pend');
    const pag  = $('#pag-pend');
    const filtered = filterRows(state.pendientes, state.termPend);
    const { slice, page, pages, total } = paginate(filtered, state.pagePend, state.sizePend);

    tb.innerHTML = '';
    if (!slice.length){
      tb.innerHTML = `<tr><td colspan="9" class="text-center text-muted">Sin resultados</td></tr>`;
    } else {
      slice.forEach(o=>{
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${o.Fecha||''}</td>
          <td><a href="/admin/ordenes/detalle/${o.IdOrden}" target="_blank">#${o.IdOrden}</a>${o.FolioOrden?` · ${o.FolioOrden}`:''}</td>
          <td>${o.Cliente||'—'}</td>
          <td style="min-width:280px">${o.Domicilio||'—'}</td>
          <td><span class="badge bg-danger text-white">${o.PagoCanon}</span></td>
          <td><span class="badge ${o.EstadoTransito==16?'bg-warning text-dark':'bg-dark'}">${o.EstadoTransito}</span></td>
          <td style="min-width:170px">
            <select class="form-select form-select-sm sel-dep" data-id="${o.IdOrden}">
              <option value="22">Reparto 1 (22)</option>
              <option value="14">Reparto 2 (14)</option>
            </select>
          </td>
          <td style="min-width:220px">
            <select class="form-select form-select-sm sel-rep" data-id="${o.IdOrden}">${optReps(22)}</select>
          </td>
          <td>
            <button class="btn btn-sm btn-danger act-asignar" data-id="${o.IdOrden}">Asignar</button>
          </td>
        `;
        tb.appendChild(tr);
      });
    }
    info.textContent = `${total} registro(s) · pág ${page}/${pages}`;
    renderPager(pag, page, pages, (go)=>{ state.pagePend = go; renderPendientes(); });

    tb.onchange = (ev)=>{
      const selDep = ev.target.closest('.sel-dep');
      if (selDep){
        const id = selDep.getAttribute('data-id');
        const dep = Number(selDep.value);
        const selRep = tb.querySelector(`.sel-rep[data-id="${id}"]`);
        selRep.innerHTML = optReps(dep);
      }
    };

    tb.onclick = async (ev)=>{
      const btn = ev.target.closest('.act-asignar'); if (!btn) return;
      const id  = btn.getAttribute('data-id');
      const depSel = tb.querySelector(`.sel-dep[data-id="${id}"]`);
      const repSel = tb.querySelector(`.sel-rep[data-id="${id}"]`);
      const dep = Number(depSel?.value || 0);
      const usr = Number(repSel?.value || 0);
      if (!dep || !usr){
        Swal.fire({ icon:'warning', title:'Falta información', text:'Selecciona departamento y repartidor', theme: colorswal });
        return;
      }
      const actor = Number($('#Idusu')?.value || 0);

      try {
        await apiPost('reparto_asignar_orden', { IdOrden:id, Departamento:dep, IdUsuario:usr, user:actor });
        swOk('Orden asignada');
        await loadPendientes();
        await loadAsignadas();
        $('#tab-asig').click();
      } catch(e) {
        swErr(e.message);
      }
    };
  }

  function renderAsignadas(){
    const tb   = $('#tb-asig');
    const info = $('#info-asig');
    const pag  = $('#pag-asig');
    const filtered = filterRows(state.asignadas, state.termAsig);
    const { slice, page, pages, total } = paginate(filtered, state.pageAsig, state.sizeAsig);

    tb.innerHTML = '';
    if (!slice.length){
      tb.innerHTML = `<tr><td colspan="8" class="text-center text-muted">Sin resultados</td></tr>`;
    } else {
      slice.forEach(o=>{
        const badge = o.estatus_reparto==='ENTREGADA' ? 'bg-success'
                    : o.estatus_reparto==='EN_RUTA'   ? 'bg-info text-dark'
                    : o.estatus_reparto==='CANCELADA' ? 'bg-secondary'
                    : 'bg-dark';
        const devolverBtnClass = theme()==='dark' ? 'btn btn-outline-light' : 'btn btn-outline-secondary';
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${o.Fecha||''}</td>
          <td><a href="/admin/ordenes/detalle/${o.IdOrden}" target="_blank">#${o.IdOrden}</a>${o.FolioOrden?` · ${o.FolioOrden}`:''}</td>
          <td>${o.Cliente||'—'}</td>
          <td style="min-width:280px">${o.Domicilio||'—'}</td>
          <td>${o.Repartidor || '—'}</td>
          <td>${o.Departamento}</td>
          <td><span class="badge ${badge}">${o.estatus_reparto || 'ASIGNADA'}</span></td>
          <td>
            <div class="btn-group btn-group-sm">
              <button class="btn btn-outline-danger act-ruta" data-id="${o.IdOrden}">En ruta</button>
              <button class="btn btn-danger act-entregar" data-id="${o.IdOrden}">Entregar</button>
              <button class="${devolverBtnClass} act-devolver" data-id="${o.IdOrden}">Devolver 21</button>
              <button class="btn btn-outline-danger act-reasignar" data-id="${o.IdOrden}">Reasignar</button>
            </div>
          </td>
        `;
        tb.appendChild(tr);
      });
    }
    info.textContent = `${total} registro(s) · pág ${page}/${pages}`;
    renderPager(pag, page, pages, (go)=>{ state.pageAsig = go; renderAsignadas(); });

    tb.onclick = async (ev)=>{
      const id = ev.target.getAttribute('data-id'); if (!id) return;

      if (ev.target.classList.contains('act-ruta')){
        try {
          await apiPost('reparto_en_ruta', { IdOrden:id, user: ($('#Idusu')?.value||0) });
          swOk('Estatus actualizado', 'Orden marcada EN RUTA');
          await loadAsignadas();
        } catch(e){ swErr(e.message); }
      }

      if (ev.target.classList.contains('act-entregar')){
        window.open(`/admin/ordenes/detalle/${id}`, '_blank');
      }

      if (ev.target.classList.contains('act-devolver')){
        const { value: motivo, isConfirmed } = await Swal.fire({
          title: 'Motivo devolución a almacén (21)',
          input: 'text',
          inputValue: 'Cliente no ubicable',
          inputPlaceholder: 'Describe el motivo',
          showCancelButton: true,
          confirmButtonText: 'Devolver',
          cancelButtonText: 'Cancelar',
          theme: colorswal
        });
        if (!isConfirmed) return;
        try {
          await apiPost('reparto_devolver_almacen', { IdOrden:id, motivo: motivo || 'Devuelto a almacén', user: ($('#Idusu')?.value||0) });
          swOk('Devuelto a almacén');
          await loadPendientes();
          await loadAsignadas();
          $('#tab-pend').click();
        } catch(e){ swErr(e.message); }
      }

      if (ev.target.classList.contains('act-reasignar')){
        // Paso 1: elegir departamento
        const { value: dep, isConfirmed: ok1 } = await Swal.fire({
          title: 'Departamento destino',
          input: 'select',
          inputOptions: { '22':'Reparto 1 (22)', '14':'Reparto 2 (14)' },
          inputValue: '22',
          showCancelButton: true,
          confirmButtonText: 'Siguiente',
          cancelButtonText: 'Cancelar',
          theme: colorswal
        });
        if (!ok1) return;

        const list = (Number(dep)===14 ? state.reps14 : state.reps22);
        if (!list.length){
          return swErr('No hay repartidores en ese departamento');
        }
        const opts = {};
        list.forEach(x => { opts[String(x.IdUsuario)] = x.Usuario; });

        // Paso 2: elegir repartidor
        const { value: usr, isConfirmed: ok2 } = await Swal.fire({
          title: 'Repartidor',
          input: 'select',
          inputOptions: opts,
          inputPlaceholder: 'Selecciona repartidor',
          showCancelButton: true,
          confirmButtonText: 'Reasignar',
          cancelButtonText: 'Cancelar',
          theme: colorswal
        });
        if (!ok2 || !usr) return;

        try {
          await apiPost('reparto_reasignar', { IdOrden:id, Departamento:Number(dep), IdUsuario:Number(usr), user: ($('#Idusu')?.value||0) });
          swOk('Orden reasignada');
          await loadAsignadas();
        } catch(e){ swErr(e.message); }
      }
    };
  }

  // ===== Cargas =====
  async function loadRepartidores(){
    try {
      state.reps22 = await apiPost('reparto_repartidores_list', { Departamento:22 }) || [];
      state.reps14 = await apiPost('reparto_repartidores_list', { Departamento:14 }) || [];
    } catch(e){ swErr(e.message); }
  }

  async function loadPendientes(){
    const ini = $('#fini')?.value ? ($('#fini').value + ' 00:00:00') : '';
    const fin = $('#ffin')?.value ? ($('#ffin').value + ' 23:59:59') : '';
    try {
      const rows = await apiPost('reparto_ordenes_pendientes', { ini, fin }) || [];
      state.pendientes = rows.map(r=>{
        const TipoPagoNombre = r.TipoPagoNombre || r.DescripcionTipoPago || r.Descripcion || r.TipoPago;
        const PagoCanon = canonPago(r.TipoPago, TipoPagoNombre);
        return {
          ...r,
          Cliente: r.Cliente || r.cliente || '',
          Domicilio: buildDomicilio(r),
          TipoPagoNombre,
          PagoCanon
        };
      });
      renderPendientes();
    } catch(e){ swErr(e.message); }
  }

  async function loadAsignadas(){
    try {
      const rows = await apiPost('reparto_ordenes_asignadas', {}) || [];
      state.asignadas = rows.map(r=>{
        const TipoPagoNombre = r.TipoPagoNombre || r.DescripcionTipoPago || r.Descripcion || r.TipoPago;
        const PagoCanon = canonPago(r.TipoPago, TipoPagoNombre);
        return {
          ...r,
          Cliente: r.Cliente || r.cliente || '',
          Domicilio: buildDomicilio(r),
          TipoPagoNombre,
          PagoCanon
        };
      });
      renderAsignadas();
    } catch(e){ swErr(e.message); }
  }

  // ===== Start =====
  document.addEventListener('DOMContentLoaded', async ()=>{
    const root = $('#'+ROOT_ID); if (!root) return;
    buildUI(root);
    await loadRepartidores();
    await loadPendientes();
    await loadAsignadas();
  });
})();


