$(document).ready(function () {
    $('.codi_add_subcategoria').on('submit', codi_add_subcategoria);
    function codi_add_subcategoria(event) {
        console.log('r')
        event.preventDefault();
        var form = $('.codi_add_subcategoria'),
            hook = 'codi_hook',
            action = 'add',
            data = new FormData(form.get(0));
        data.append('hook', hook);
        data.append('action', action);

        // AJAX Productos
        $.ajax({
            url: '../ajax/codi_add_subcategoria',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 201) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                window.location.href = "";
                form.trigger('reset');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });


    }

    //Obtener Moviemientos
    codi_get_categorias(NioApp);
    function codi_get_categorias(NioApp) {
        var wrapper = $('.tabla_wrapper_categorias'),
            hook = 'codi_hook',
            action = 'load';

        // AJAX Productos Get
        $.ajax({
            url: '../ajax/codi_get_categoriap_select',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {
                // wrapper.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {
                // wrapper.waitMe('hide');
            });

    }

    //Obtener Moviemientos
    codi_get_subcategorias(NioApp);
    function codi_get_subcategorias(NioApp) {
        var wrapper = $('.tabla_wrapper_subcategorias'),
            hook = 'codi_hook',
            action = 'load';
        console.log('reaad')

        // AJAX Productos Get
        $.ajax({
            url: '../ajax/codi_get_subcategorias',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: { hook, action },
            beforeSend: function () {
                // wrapper.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                wrapper.html(res.data);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion',
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');

            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
                wrapper.html('');
            })
            .always(function () {
                // wrapper.waitMe('hide');
            });

    }

    $('#modalEditar').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var idsubcat = button.data('idsubcat');

        var nombresubcat = button.data('nombresubcat');
        var categoriaid = button.data('categoriaid');
        console.log(nombresubcat);
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#idsubcat').val(idsubcat)
        modal.find('#nombresubcat').val(nombresubcat)
        modal.find('#categoriaid').val(categoriaid).trigger("onchange");
    })

    $('#modalEliminar').on('show.bs.modal', function (event) {
        var button = $(event.relatedTarget) // Button that triggered the modal
        var id = button.data('edidsubcat');
        var cn = button.data('nombresubcat');
        // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        var modal = $(this)
        modal.find('#edid').val(id)
        modal.find('#EcatNombre').text(cn)
    })

    $('.codi_update_subcategoria').on('submit', codi_update_subcategoria);
    function codi_update_subcategoria(event) {
        event.preventDefault();

        var form = $('.codi_update_subcategoria'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData(form.get(0));
        data.append('hook', hook);
        data.append('action', action);
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Almacen
        $.ajax({
            url: '../ajax/codi_update_subcategoria',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                window.location.href = "";
                form.trigger('reset');
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

    //Eliminar Moviemiento
    $('.codi_delete_subcategoria').on('click', codi_delete_subcategoria);
    function codi_delete_subcategoria(event) {
        event.preventDefault();
        var catId = $('#edid').val()
        console.log(catId)
        var form = $('.codi_delete_subcategoria'),
            hook = 'codi_hook',
            action = 'update',
            data = new FormData();
        data.append('hook', hook);
        data.append('action', action);
        data.append('activo', 400);
        data.append('catId', catId)
        /*for (var pair of data.entries()) {
            console.log(pair[0]+ ', ' + pair[1]); 
        }*/
        // AJAX Usuarios
        $.ajax({
            url: '../ajax/codi_delete_subcategoria',
            type: 'POST',
            dataType: 'json',
            contentType: false,
            processData: false,
            cache: false,
            data: data,
            beforeSend: function () {
                // form.waitMe();
            }
        }).done(function (res) {
            if (res.status === 200) {
                Swal.fire({
                    icon: 'success',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
                form.trigger('reset');
                window.location.reload()
            } else {
                Swal.fire({
                    icon: 'error',
                    title: res.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        })
            .fail(function (err) {
                Swal.fire({
                    icon: 'error',
                    title: 'Hubo un error en la peticion'.err,
                    showConfirmButton: false,
                    timer: 1500
                })
            })
            .always(function () {
                // form.waitMe('hide');
            });

    }

})