/* ============================ taller.js (FUNDEV) ============================ */
(() => {
  const API_BASE = 'https://grupoxtinfire.com/admin/ajax/';
  const HOOK = 'codi_hook';
  const ACTION = 'load';
  const ROOT_ID = 'taller-card-body';
  const $ = (s,c=document)=>c.querySelector(s);
  const $$ = (s,c=document)=>Array.from(c.querySelectorAll(s));
  const colorswal = (typeof colortema === 'function') ? colortema() : 'default';

  async function apiPost(fnName, params={}) {
    const body = new URLSearchParams({ hook: HOOK, action: ACTION, ...params });
    const r = await fetch(API_BASE + fnName, {
      method: 'POST',
      headers: { 'Content-Type':'application/x-www-form-urlencoded;charset=UTF-8' },
      body
    });
    const j = await r.json();
    if (!r.ok || j.error) throw new Error(j.data || j.msg || 'API error');
    return j.data;
  }
  const swErr = (msg) => Swal.fire({ icon:'error', title:'Error', text:String(msg||'Ocurrió un error'), theme: colorswal });
  const swOk  = (title='Hecho', text='') => Swal.fire({ icon:'success', title, text, timer:1400, showConfirmButton:false, theme: colorswal });

  const pad = n => String(n).padStart(2,'0');
  function prevMonthFirstToToday(){
    const n = new Date();
    const y = n.getFullYear(), m = n.getMonth();
    const firstPrev = new Date(m===0 ? y-1 : y, m===0 ? 11 : m-1, 1);
    return {
      d1: `${firstPrev.getFullYear()}-${pad(firstPrev.getMonth()+1)}-${pad(firstPrev.getDate())}`,
      d2: `${n.getFullYear()}-${pad(n.getMonth()+1)}-${pad(n.getDate())}`,
    };
  }

  let state = {
    tipo2: [], tipo8: [], resguardo: [],
    term2: '', term8:'', termRes:'',
    p2:1, p8:1, pR:1,
    s2:10, s8:10, sR:10,
    ini: '', fin: '',
    resumen: null,
    tick: 0
  };

  let LIVE_TICKER = null;
  function ensureLiveTicker(){
    if (LIVE_TICKER) return;
    LIVE_TICKER = setInterval(repaintLiveBadges, 1000);
    repaintLiveBadges();
  }

  function parseStart(iso){
    if (!iso) return null;
    const s = String(iso).replace(' ', 'T');
    const d = new Date(s);
    return isNaN(d.getTime()) ? null : d;
  }

  function computeLive(fromDate){
    if (!fromDate) return { label:'—', cls:'bg-secondary' };
    const now = new Date();
    const ms  = Math.max(0, now - fromDate);
    const hrs = Math.floor(ms/3600000);
    const mins= Math.floor((ms%3600000)/60000);
    let cls   = 'bg-success';
    if (hrs >= 24 && hrs < 48) cls = 'bg-warning text-dark';
    if (hrs >= 48) cls = 'bg-danger';
    return { label: `${pad(hrs)}h ${pad(mins)}m`, cls };
  }

  function repaintLiveBadges(){
    const nodes = $$('.live-badge');
    nodes.forEach(el=>{
      const startIso = el.getAttribute('data-live-start');
      const stopIso  = el.getAttribute('data-live-stop');
      if (!startIso || stopIso) return;
      const d = parseStart(startIso);
      const { label, cls } = computeLive(d);
      el.textContent = label;
      el.className = `badge ${cls} live-badge`;
    });
  }

  function filterRows(rows, term){
    if (!term) return rows;
    const t = term.toLowerCase();
    return rows.filter(r=>{
      const s = [
        r.IdOrden, r.FolioOrden, r.Cliente, r.Domicilio,
        r.TipoPagoNombre, r.estatus_taller, r.motivo_resguardo
      ].map(v=> (v??'').toString().toLowerCase()).join(' ');
      return s.includes(t);
    });
  }
  function paginate(rows, page, size){
    const total = rows.length;
    const pages = Math.max(1, Math.ceil(total/size));
    const p = Math.min(Math.max(1,page), pages);
    const start = (p-1)*size;
    return { slice: rows.slice(start, start+size), page:p, pages, total };
  }
  function renderPager(container, page, pages, onJump){
    container.innerHTML = '';
    const mk = (txt, go, disabled=false, active=false)=>{
      const b = document.createElement('button');
      b.className = 'btn btn-sm ' + (active ? 'btn-danger text-white' : 'btn-outline-danger');
      b.disabled = !!disabled;
      b.textContent = txt;
      if (!disabled) b.onclick = ()=>onJump(go);
      container.appendChild(b);
    };
    mk('«', 1, page===1);
    mk('‹', page-1, page===1);
    for (let i=Math.max(1,page-2); i<=Math.min(pages,page+2); i++) mk(String(i), i, false, i===page);
    mk('›', page+1, page===pages);
    mk('»', pages, page===pages);
  }

  function diffHrsStr(fromIso){
    if (!fromIso) return {label:'—', hrs:null, cls:'bg-secondary'};
    const start = parseStart(fromIso);
    const now   = new Date();
    const ms    = now - start;
    const hrs   = Math.floor(ms/3600000);
    const mins  = Math.floor((ms%3600000)/60000);
    let cls     = 'bg-success';
    if (hrs >= 24 && hrs < 48) cls = 'bg-warning text-dark';
    if (hrs >= 48) cls = 'bg-danger';
    return { label: `${pad(hrs)}h ${pad(mins)}m`, hrs, cls };
  }

  function diffBetween(startIso, endIso){
    if (!startIso || !endIso) return {label:'—', cls:'bg-secondary'};
    const s = parseStart(startIso), e = parseStart(endIso);
    if (!s || !e) return {label:'—', cls:'bg-secondary'};
    const ms  = Math.max(0, e - s);
    const hrs = Math.floor(ms/3600000);
    const mins= Math.floor((ms%3600000)/60000);
    let cls   = 'bg-success';
    if (hrs >= 24 && hrs < 48) cls = 'bg-warning text-dark';
    if (hrs >= 48) cls = 'bg-danger';
    return { label: `${pad(hrs)}h ${pad(mins)}m`, cls };
  }

  function buildUI(root){
    const range = prevMonthFirstToToday();
    state.ini = range.d1; state.fin = range.d2;

    root.innerHTML = `
      <div class="row g-3 mb-3">
        <div class="col-12">
          <div class="card"><div class="card-body">
            <div class="d-flex align-items-center justify-content-between">
              <h6 class="mb-0">Resumen Taller — Recarga y mantenimiento</h6>
              <div class="d-flex gap-2">
                <input id="fini" type="date" class="form-control form-control-sm" style="max-width:160px">
                <input id="ffin" type="date" class="form-control form-control-sm" style="max-width:160px">
                <button id="btn-buscar" class="btn btn-sm btn-dark">Actualizar</button>
              </div>
            </div>
            <div class="row text-center mt-3" id="cards-resumen"></div>
          </div></div>
        </div>
      </div>

      <div class="row g-3 mb-3">
        <div class="col-12">
          <div class="card h-100"><div class="card-body d-flex flex-column justify-content-center">
            <div class="d-flex gap-2 flex-wrap">
              <button id="tab-t2"  class="btn btn-danger text-white flex-fill">En taller: Recarga y mantenimiento</button>
              <button id="tab-t8"  class="btn btn-outline-danger flex-fill">En taller: Solicitudes de taller</button>
              <button id="tab-res" class="btn btn-outline-danger flex-fill">Resguardo de almacén</button>
            </div>
          </div></div>
        </div>
      </div>

      <div id="view-t2" class="card">
        <div class="card-body">
          <div class="d-flex flex-wrap justify-content-between gap-2 mb-2">
            <input id="srch-t2" type="search" class="form-control form-control-sm" placeholder="Buscar orden/cliente/domicilio…" style="max-width:320px">
            <div><label class="me-2 small">Filas</label>
              <select id="size-t2" class="form-select form-select-sm" style="width:84px;">
                <option>10</option><option>25</option><option>50</option>
              </select></div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead>
                <tr>
                  <th>Fecha</th><th>Orden</th><th>Cliente</th><th>Domicilio</th>
                  <th>Pago</th><th>Inicio</th><th>Transcurrido</th><th>Estatus</th><th>Acciones</th>
                </tr>
              </thead>
              <tbody id="tb-t2"></tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small" id="info-t2"></div>
            <div id="pag-t2" class="btn-group"></div>
          </div>
        </div>
      </div>

      <div id="view-t8" class="card d-none">
        <div class="card-body">
          <div class="d-flex flex-wrap justify-content-between gap-2 mb-2">
            <input id="srch-t8" type="search" class="form-control form-control-sm" placeholder="Buscar orden/cliente/domicilio…" style="max-width:320px">
            <div><label class="me-2 small">Filas</label>
              <select id="size-t8" class="form-select form-select-sm" style="width:84px;">
                <option>10</option><option>25</option><option>50</option>
              </select></div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead>
                <tr>
                  <th>Fecha</th><th>Orden</th><th>Cliente</th><th>Domicilio</th>
                  <th>Inicio</th><th>Transcurrido</th><th>Estatus</th><th>Acciones</th>
                </tr>
              </thead>
              <tbody id="tb-t8"></tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small" id="info-t8"></div>
            <div id="pag-t8" class="btn-group"></div>
          </div>
        </div>
      </div>

      <div id="view-res" class="card d-none">
        <div class="card-body">
          <div class="d-flex flex-wrap justify-content-between gap-2 mb-2">
            <input id="srch-res" type="search" class="form-control form-control-sm" placeholder="Buscar orden/cliente/domicilio/motivo…" style="max-width:360px">
            <div><label class="me-2 small">Filas</label>
              <select id="size-res" class="form-select form-select-sm" style="width:84px;">
                <option>10</option><option>25</option><option>50</option>
              </select></div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead>
                <tr>
                  <th>Fecha</th><th>Orden</th><th>Cliente</th><th>Domicilio</th>
                  <th>Motivo</th><th>Comentario</th><th>Desde</th><th>Transcurrido</th><th>Acción</th>
                </tr>
              </thead>
              <tbody id="tb-res"></tbody>
            </table>
          </div>
          <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="small" id="info-res"></div>
            <div id="pag-res" class="btn-group"></div>
          </div>
        </div>
      </div>
    `;

    $('#fini').value = state.ini;
    $('#ffin').value = state.fin;

    $('#btn-buscar').onclick = async ()=>{
      state.ini = $('#fini').value || state.ini;
      state.fin = $('#ffin').value || state.fin;
      try { await loadResumen(); swOk('Resumen actualizado'); } catch(e){ swErr(e.message); }
    };

    const setTab = (name)=>{
      const t2=$('#tab-t2'), t8=$('#tab-t8'), tr=$('#tab-res');
      const v2=$('#view-t2'), v8=$('#view-t8'), vr=$('#view-res');
      if (name==='t2'){
        v2.classList.remove('d-none'); v8.classList.add('d-none'); vr.classList.add('d-none');
        t2.className='btn btn-danger text-white flex-fill'; t8.className='btn btn-outline-danger flex-fill'; tr.className='btn btn-outline-danger flex-fill';
      } else if (name==='t8'){
        v8.classList.remove('d-none'); v2.classList.add('d-none'); vr.classList.add('d-none');
        t8.className='btn btn-danger text-white flex-fill'; t2.className='btn btn-outline-danger flex-fill'; tr.className='btn btn-outline-danger flex-fill';
      } else {
        vr.classList.remove('d-none'); v2.classList.add('d-none'); v8.classList.add('d-none');
        tr.className='btn btn-danger text-white flex-fill'; t2.className='btn btn-outline-danger flex-fill'; t8.className='btn btn-outline-danger flex-fill';
      }
    };
    $('#tab-t2').onclick = ()=>setTab('t2');
    $('#tab-t8').onclick = ()=>setTab('t8');
    $('#tab-res').onclick = ()=>setTab('res');

    $('#srch-t2').oninput = e=>{ state.term2=e.target.value.trim(); state.p2=1; renderTipo2(); };
    $('#srch-t8').oninput = e=>{ state.term8=e.target.value.trim(); state.p8=1; renderTipo8(); };
    $('#srch-res').oninput = e=>{ state.termRes=e.target.value.trim(); state.pR=1; renderRes(); };
    $('#size-t2').onchange = e=>{ state.s2=parseInt(e.target.value,10)||10; state.p2=1; renderTipo2(); };
    $('#size-t8').onchange = e=>{ state.s8=parseInt(e.target.value,10)||10; state.p8=1; renderTipo8(); };
    $('#size-res').onchange = e=>{ state.sR=parseInt(e.target.value,10)||10; state.pR=1; renderRes(); };
  }

  function rowTallerActions(o, tableId){
    const startBtn = `<button class="btn btn-outline-danger btn-sm act-start" data-id="${o.IdOrden}">Iniciar</button>`;
    const endBtn   = `<button class="btn btn-danger btn-sm act-end" data-id="${o.IdOrden}">Terminar</button>`;
    const resBtn   = `<button class="btn btn-outline-danger btn-sm act-res" data-id="${o.IdOrden}">Resguardo</button>`;
    const verBtn   = `<button class="btn btn-outline-danger btn-sm act-ver" data-id="${o.IdOrden}">Ver</button>`;
    const canStart = !o.ts_inicio;
    const canEnd   = !!o.ts_inicio && !o.ts_fin;
    return `
      <div class="btn-group btn-group-sm" data-tbl="${tableId}">
        ${verBtn}
        ${canStart ? startBtn : ''}
        ${canEnd   ? endBtn : ''}
        ${resBtn}
      </div>`;
  }

  function renderCardsResumen(){
    const c = $('#cards-resumen');
    const r = state.resumen || {};
    c.innerHTML = `
      <div class="col-6 col-md-4 col-xl-3">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="small text-muted">Órdenes/día</div>
          <div class="fs-4 fw-bold">${(r.prom_ordenes_dia ?? 0).toFixed(2)}%</div>
        </div></div>
      </div>
      <div class="col-6 col-md-4 col-xl-3">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="small text-muted">Extintores/orden</div>
          <div class="fs-4 fw-bold">${(r.prom_extintores_por_orden ?? 0).toFixed(2)}</div>
        </div></div>
      </div>
      <div class="col-6 col-md-4 col-xl-3">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="small text-muted">Promedio duración</div>
          <div class="fs-4 fw-bold">${(r.prom_duracion_horas ?? 0).toFixed(2)} h</div>
        </div></div>
      </div>
      <div class="col-6 col-md-4 col-xl-3">
        <div class="card border-0 shadow-sm"><div class="card-body text-center">
          <div class="small text-muted">&lt;24h / 24–48h / &gt;48h</div>
          <div class="fs-6 fw-bold">
            <span class="badge bg-success">${r.activas_lt24 ?? 0}</span>
            <span class="badge bg-warning text-dark">${r.activas_24_48 ?? 0}</span>
            <span class="badge bg-danger">${r.activas_gt48 ?? 0}</span>
            <span class="badge bg-secondary ms-2">Terminadas: ${r.terminadas ?? 0}</span>
          </div>
        </div></div>
      </div>
    `;
  }

  function renderTipo2(){
    const tb = $('#tb-t2'), info=$('#info-t2'), pag=$('#pag-t2');
    const filtered = filterRows(state.tipo2, state.term2);
    const { slice, page, pages, total } = paginate(filtered, state.p2, state.s2);
    tb.innerHTML = '';
    if (!slice.length){
      tb.innerHTML = `<tr><td colspan="9" class="text-center text-muted">Sin resultados</td></tr>`;
    } else {
      slice.forEach(o=>{
        const live = (o.ts_inicio && !o.ts_fin) ? o.ts_inicio : null;
        const ended = (o.ts_inicio && o.ts_fin) ? diffBetween(o.ts_inicio, o.ts_fin) : null;
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${o.Fecha||''}</td>
          <td><a href="/admin/ordenes/detalle/${o.IdOrden}" target="_blank">#${o.IdOrden}</a>${o.FolioOrden?` · ${o.FolioOrden}`:''}</td>
          <td>${o.Cliente||'—'}</td>
          <td style="min-width:280px">${o.Domicilio||'—'}</td>
          <td>${o.TipoPagoNombre||'—'}</td>
          <td>${o.ts_inicio||'—'}</td>
          <td>${
            live
              ? `<span class="badge live-badge" data-live-start="${live}"></span>`
              : (ended
                  ? `<span class="badge ${ended.cls}" data-live-stop="${o.ts_fin}">${ended.label}</span>`
                  : (()=>{ const t = diffHrsStr(null); return `<span class="badge ${t.cls}">${t.label}</span>` })()
                )
          }</td>
          <td><span class="badge ${o.ts_fin?'bg-secondary':'bg-info text-dark'}">${o.ts_fin?'TERMINADA':'EN PROCESO'}</span></td>
          <td>${rowTallerActions(o,'t2')}</td>
        `;
        tb.appendChild(tr);
      });
    }
    info.textContent = `${total} registro(s) · pág ${page}/${pages}`;
    renderPager(pag, page, pages, (go)=>{ state.p2=go; renderTipo2(); });
    ensureLiveTicker();

    tb.onclick = async (ev)=>{
      const btn = ev.target.closest('button'); if (!btn) return;
      const id = Number(btn.getAttribute('data-id')); if (!id) return;
      if (btn.classList.contains('act-ver')){
        window.open(`/admin/ordenes/detalle/${id}`,'_blank'); return;
      }
      if (btn.classList.contains('act-start')){
        try { await apiPost('taller_iniciar_trabajo', { IdOrden:id, user: ($('#Idusu')?.value||0) }); swOk('Orden en proceso'); await loadTipo(2); }
        catch(e){ swErr(e.message); }
      }
      if (btn.classList.contains('act-end')){
        const ok = await Swal.fire({title:'Terminar orden', text:'¿Confirmas marcar como TERMINADA?', icon:'question', showCancelButton:true, confirmButtonText:'Sí, terminar', cancelButtonText:'Cancelar', theme: colorswal}).then(r=>r.isConfirmed);
        if (!ok) return;
        try { await apiPost('taller_terminar_orden', { IdOrden:id, user: ($('#Idusu')?.value||0) }); swOk('Orden terminada'); await loadTipo(2); await loadResumen(); }
        catch(e){ swErr(e.message); }
      }
      if (btn.classList.contains('act-res')){
        await modalResguardo(id);
      }
    };
  }

  function renderTipo8(){
    const tb = $('#tb-t8'), info=$('#info-t8'), pag=$('#pag-t8');
    const filtered = filterRows(state.tipo8, state.term8);
    const { slice, page, pages, total } = paginate(filtered, state.p8, state.s8);
    tb.innerHTML = '';
    if (!slice.length){
      tb.innerHTML = `<tr><td colspan="8" class="text-center text-muted">Sin resultados</td></tr>`;
    } else {
      slice.forEach(o=>{
        const live = (o.ts_inicio && !o.ts_fin) ? o.ts_inicio : null;
        const ended = (o.ts_inicio && o.ts_fin) ? diffBetween(o.ts_inicio, o.ts_fin) : null;
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${o.Fecha||''}</td>
          <td><a href="/admin/ordenes/detalle/${o.IdOrden}" target="_blank">#${o.IdOrden}</a>${o.FolioOrden?` · ${o.FolioOrden}`:''}</td>
          <td>${o.Cliente||'—'}</td>
          <td style="min-width:280px">${o.Domicilio||'—'}</td>
          <td>${o.ts_inicio||'—'}</td>
          <td>${
            live
              ? `<span class="badge live-badge" data-live-start="${live}"></span>`
              : (ended
                  ? `<span class="badge ${ended.cls}" data-live-stop="${o.ts_fin}">${ended.label}</span>`
                  : (()=>{ const t = diffHrsStr(null); return `<span class="badge ${t.cls}">${t.label}</span>` })()
                )
          }</td>
          <td><span class="badge ${o.ts_fin?'bg-secondary':'bg-info text-dark'}">${o.ts_fin?'TERMINADA':'EN PROCESO'}</span></td>
          <td>${rowTallerActions(o,'t8')}</td>
        `;
        tb.appendChild(tr);
      });
    }
    info.textContent = `${total} registro(s) · pág ${page}/${pages}`;
    renderPager(pag, page, pages, (go)=>{ state.p8=go; renderTipo8(); });
    ensureLiveTicker();

    tb.onclick = async (ev)=>{
      const btn = ev.target.closest('button'); if (!btn) return;
      const id = Number(btn.getAttribute('data-id')); if (!id) return;
      if (btn.classList.contains('act-ver')){ window.open(`/admin/ordenes/detalle/${id}`,'_blank'); return; }
      if (btn.classList.contains('act-start')){
        try { await apiPost('taller_iniciar_trabajo', { IdOrden:id, user: ($('#Idusu')?.value||0) }); swOk('Orden en proceso'); await loadTipo(8); }
        catch(e){ swErr(e.message); }
      }
      if (btn.classList.contains('act-end')){
        const ok = await Swal.fire({title:'Terminar orden', text:'¿Confirmas marcar como TERMINADA?', icon:'question', showCancelButton:true, confirmButtonText:'Sí, terminar', cancelButtonText:'Cancelar', theme: colorswal}).then(r=>r.isConfirmed);
        if (!ok) return;
        try { await apiPost('taller_terminar_orden', { IdOrden:id, user: ($('#Idusu')?.value||0) }); swOk('Orden terminada'); await loadTipo(8); await loadResumen(); }
        catch(e){ swErr(e.message); }
      }
      if (btn.classList.contains('act-res')){ await modalResguardo(id); }
    };
  }

  function renderRes(){
    const tb = $('#tb-res'), info=$('#info-res'), pag=$('#pag-res');
    const filtered = filterRows(state.resguardo, state.termRes);
    const { slice, page, pages, total } = paginate(filtered, state.pR, state.sR);
    tb.innerHTML = '';
    if (!slice.length){
      tb.innerHTML = `<tr><td colspan="9" class="text-center text-muted">Sin resultados</td></tr>`;
    } else {
      slice.forEach(o=>{
        const live = o.ts_resguardo_inicio || null;
        const tr = document.createElement('tr');
        tr.innerHTML = `
          <td>${o.Fecha||''}</td>
          <td><a href="/admin/ordenes/detalle/${o.IdOrden}" target="_blank">#${o.IdOrden}</a>${o.FolioOrden?` · ${o.FolioOrden}`:''}</td>
          <td>${o.Cliente||'—'}</td>
          <td style="min-width:280px">${o.Domicilio||'—'}</td>
          <td>${o.motivo_resguardo||'—'}</td>
          <td>${o.comentario_resguardo||'—'}</td>
          <td>${o.ts_resguardo_inicio||'—'}</td>
          <td>${
            live
              ? `<span class="badge live-badge" data-live-start="${live}"></span>`
              : `<span class="badge bg-secondary">—</span>`
          }</td>
          <td><button class="btn btn-outline-danger btn-sm act-ver" data-id="${o.IdOrden}">Ver</button></td>
        `;
        tb.appendChild(tr);
      });
    }
    info.textContent = `${total} registro(s) · pág ${page}/${pages}`;
    renderPager(pag, page, pages, (go)=>{ state.pR=go; renderRes(); });
    ensureLiveTicker();

    tb.onclick = (ev)=>{
      const btn = ev.target.closest('button'); if (!btn) return;
      const id = Number(btn.getAttribute('data-id')); if (!id) return;
      if (btn.classList.contains('act-ver')) window.open(`/admin/ordenes/detalle/${id}`,'_blank');
    };
  }

  async function modalResguardo(IdOrden){
    const html = `
      <div class="text-start">
        <label class="form-label">Motivo</label>
        <select id="motivo-res" class="form-select">
          <option>No hay inventario se necesita una refacción</option>
          <option>Solicitado por Gerente</option>
          <option>Se terminó pero se envió a resguardo</option>
        </select>
        <label class="form-label mt-2">Comentario adicional</label>
        <textarea id="coment-res" class="form-control" rows="3" placeholder="Detalles..."></textarea>
      </div>
    `;
    const { isConfirmed } = await Swal.fire({
      title: 'Enviar a Resguardo de Almacén (32)',
      html, focusConfirm:false, showCancelButton:true,
      confirmButtonText: 'Enviar', cancelButtonText:'Cancelar', theme: colorswal,
      preConfirm: ()=>{
        return {
          motivo: document.getElementById('motivo-res').value,
          comentario: document.getElementById('coment-res').value?.trim() || ''
        };
      }
    });
    if (!isConfirmed) return;
    const motivo = document.getElementById('motivo-res').value;
    const comentario = document.getElementById('coment-res').value?.trim() || '';
    try {
      await apiPost('taller_enviar_resguardo', { IdOrden: IdOrden, motivo, comentario, user: ($('#Idusu')?.value||0) });
      swOk('Enviado a Resguardo');
      await loadTipo(2);
      await loadTipo(8);
      await loadResguardo();
      $('#tab-res').click();
    } catch(e){ swErr(e.message); }
  }

  function buildDomicilio(r){
    if (r.Domicilio) return r.Domicilio;
    const parts = [r.EntCalle, r.EntNExt, r.EntNInt, r.EntColonia, r.EntCP, r.EntMunicipio, r.EntEstado]
      .map(x => (x??'').toString().trim()).filter(Boolean);
    return parts.join(' ');
  }

  async function loadTipo(tipo){
    const rows = await apiPost('taller_ordenes_en_taller', { TipoOrden: tipo });
    const norm = (rows||[]).map(r=>({
      ...r,
      Cliente: r.Cliente || r.cliente || '',
      Domicilio: buildDomicilio(r)
    }));
    if (tipo===2){ state.tipo2 = norm; renderTipo2(); }
    else { state.tipo8 = norm; renderTipo8(); }
  }
  async function loadResguardo(){
    state.resguardo = await apiPost('taller_resguardo_list', {}) || [];
    state.resguardo = state.resguardo.map(r=>({ ...r, Cliente: r.Cliente||r.cliente||'', Domicilio: buildDomicilio(r) }));
    renderRes();
  }
  async function loadResumen(){
    state.resumen = await apiPost('taller_resumen_metrics', { ini: state.ini, fin: state.fin }) || null;
    renderCardsResumen();
  }

  setInterval(()=>{
    state.tick++;
    if (!$('#view-t2')?.classList.contains('d-none')) renderTipo2();
    if (!$('#view-t8')?.classList.contains('d-none')) renderTipo8();
    if (!$('#view-res')?.classList.contains('d-none')) renderRes();
  }, 60000);

  document.addEventListener('DOMContentLoaded', async ()=>{
    const root = $('#'+ROOT_ID); if (!root) return;
    buildUI(root);
    try {
      await Promise.all([loadTipo(2), loadTipo(8), loadResguardo(), loadResumen()]);
      ensureLiveTicker();
    } catch(e){ swErr(e.message); }
  });
})();

