
function Unidades(num){

    switch(num)
    {
        case 1: return "UN";
        case 2: return "DOS";
        case 3: return "TRES";
        case 4: return "CUATRO";
        case 5: return "CINCO";
        case 6: return "SEIS";
        case 7: return "SIETE";
        case 8: return "OCHO";
        case 9: return "NUEVE";
    }

    return "";
}//Unidades()

function Decenas(num){

    decena = Math.floor(num/10);
    unidad = num - (decena * 10);

    switch(decena)
    {
        case 1:
            switch(unidad)
            {
                case 0: return "DIEZ";
                case 1: return "ONCE";
                case 2: return "DOCE";
                case 3: return "TRECE";
                case 4: return "CATORCE";
                case 5: return "QUINCE";
                default: return "DIECI" + Unidades(unidad);
            }
        case 2:
            switch(unidad)
            {
                case 0: return "VEINTE";
                default: return "VEINTI" + Unidades(unidad);
            }
        case 3: return DecenasY("TREINTA", unidad);
        case 4: return DecenasY("CUARENTA", unidad);
        case 5: return DecenasY("CINCUENTA", unidad);
        case 6: return DecenasY("SESENTA", unidad);
        case 7: return DecenasY("SETENTA", unidad);
        case 8: return DecenasY("OCHENTA", unidad);
        case 9: return DecenasY("NOVENTA", unidad);
        case 0: return Unidades(unidad);
    }
}//Unidades()

function DecenasY(strSin, numUnidades) {
    if (numUnidades > 0)
    return strSin + " Y " + Unidades(numUnidades)

    return strSin;
}//DecenasY()

function Centenas(num) {
    centenas = Math.floor(num / 100);
    decenas = num - (centenas * 100);

    switch(centenas)
    {
        case 1:
            if (decenas > 0)
                return "CIENTO " + Decenas(decenas);
            return "CIEN";
        case 2: return "DOSCIENTOS " + Decenas(decenas);
        case 3: return "TRESCIENTOS " + Decenas(decenas);
        case 4: return "CUATROCIENTOS " + Decenas(decenas);
        case 5: return "QUINIENTOS " + Decenas(decenas);
        case 6: return "SEISCIENTOS " + Decenas(decenas);
        case 7: return "SETECIENTOS " + Decenas(decenas);
        case 8: return "OCHOCIENTOS " + Decenas(decenas);
        case 9: return "NOVECIENTOS " + Decenas(decenas);
    }

    return Decenas(decenas);
}//Centenas()

function Seccion(num, divisor, strSingular, strPlural) {
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    letras = "";

    if (cientos > 0)
        if (cientos > 1)
            letras = Centenas(cientos) + " " + strPlural;
        else
            letras = strSingular;

    if (resto > 0)
        letras += "";

    return letras;
}//Seccion()

function Miles(num) {
    divisor = 1000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMiles = Seccion(num, divisor, "UN MIL", "MIL");
    strCentenas = Centenas(resto);

    if(strMiles == "")
        return strCentenas;

    return strMiles + " " + strCentenas;
}//Miles()

function Millones(num) {
    divisor = 1000000;
    cientos = Math.floor(num / divisor)
    resto = num - (cientos * divisor)

    strMillones = Seccion(num, divisor, "UN MILLON DE", "MILLONES DE");
    strMiles = Miles(resto);

    if(strMillones == "")
        return strMiles;

    return strMillones +" "+ strMiles;
}//Millones()

function NumeroALetras(num) {
    var data = {
        numero: num,
        enteros: Math.floor(num),
        centavos: (((Math.round(num * 100)) - (Math.floor(num) * 100))),
        letrasCentavos: "",
        letrasMonedaPlural: 'PESOS',
        letrasMonedaSingular: 'PESO', 

        letrasMonedaCentavoPlural: "CENTAVOS",
        letrasMonedaCentavoSingular: "CENTAVO"
    };

    if (data.centavos > 0) {
        data.letrasCentavos = "CON " + (function (){
            if (data.centavos == 1)
                return Millones(data.centavos) + " " + data.letrasMonedaCentavoSingular;
            else
                return Millones(data.centavos) + " " + data.letrasMonedaCentavoPlural;
            })();
    };

    if(data.enteros == 0)
        return "CERO " + data.letrasMonedaPlural + " " + data.letrasCentavos;
    if (data.enteros == 1)
        return Millones(data.enteros) + " " + data.letrasMonedaSingular + " " + data.letrasCentavos;
    else
        return Millones(data.enteros) + " " + data.letrasMonedaPlural + " " + data.letrasCentavos;
}

var formato = new Intl.NumberFormat('es-MX', {
                            style: 'currency',
                            currency: 'MXN',
                        });
async function generateQRCodeDataURL(text) {
        return new Promise((resolve) => {
            const qrcode = new QRCode(document.createElement("div"), {
                text: text,
                width: 128,
                height: 128
            });
            setTimeout(() => {
                const dataURL = qrcode._oDrawing._elImage.src;
                resolve(dataURL);
            }, 500); // Wait for QR code generation
        });
    }

async function generatePDF(img,xml){
  console.log(xml);
  console.log(xml.Complemento);
  console.log(xml.Complemento.Pagos);
  console.log(Array.isArray(xml.Complemento.Pagos.Pago));
  var tipocambio
  var formapago
  var monedap
  var serie
  var rows = [];

  var pagado = 0;
  var uuid = xml.Complemento.TimbreFiscalDigital._UUID;
  var NoCertificadoSAT = xml.Complemento.TimbreFiscalDigital._NoCertificadoSAT;
  var FechaTimbrado = xml.Complemento.TimbreFiscalDigital._FechaTimbrado;
  var SelloCFD = xml.Complemento.TimbreFiscalDigital._SelloCFD;
  var SelloSAT = xml.Complemento.TimbreFiscalDigital._SelloSAT;

  if(Array.isArray(xml.Complemento.Pagos.Pago) == false){
    tipocambio = xml.Complemento.Pagos.Pago._TipoCambioP;
    formapago = xml.Complemento.Pagos.Pago._FormaDePagoP;
    monedap = xml.Complemento.Pagos.Pago._MonedaP;
    serie = xml.Complemento.Pagos.Pago.DoctoRelacionado._Serie;
    if(formapago == "01"){
        formapago = formapago + "-Efectivo";
    }else if(formapago == "02"){
        formapago = formapago + "-Cheque nominativo";
    }
    else if(formapago == "03"){
        formapago = formapago + "-Transferencia electrónica de fondos";
    }
    else if(formapago == "04"){
        formapago = formapago + "-Tarjeta de crédito";
    }
    else if(formapago == "28"){
        formapago = formapago + "-Tarjeta de débito";
    }
    else if(formapago == "30"){
        formapago = formapago + "-Aplicación de anticipos";
    }
    else if(formapago == "99"){
        formapago = formapago + "-Por definir";
    }
    pagado = xml.Complemento.Pagos.Pago.DoctoRelacionado._ImpPagado;
    var agregarpush = {"uuid": xml.Complemento.Pagos.Pago.DoctoRelacionado._IdDocumento, "serie": xml.Complemento.Pagos.Pago.DoctoRelacionado._Serie, "folio": xml.Complemento.Pagos.Pago.DoctoRelacionado._Folio,"moneda" : xml.Complemento.Pagos.Pago.DoctoRelacionado._MonedaDR,"cambio":xml.Complemento.Pagos.Pago._TipoCambioP,"pago":"","pagado":xml.Complemento.Pagos.Pago.DoctoRelacionado._ImpPagado,"insoluto":xml.Complemento.Pagos.Pago.DoctoRelacionado._ImpSaldoInsoluto};

      rows.push(agregarpush);
  }else{

    tipocambio = xml.Complemento.Pagos.Pago[0]._TipoCambioP;
    formapago = xml.Complemento.Pagos.Pago[0]._FormaDePagoP;
    monedap = xml.Complemento.Pagos.Pago[0]._MonedaP;
    serie = xml.Complemento.Pagos.Pago[0].DoctoRelacionado._Serie;
    if(formapago == "01"){
        formapago = formapago + "-Efectivo";
    }else if(formapago == "02"){
        formapago = formapago + "-Cheque nominativo";
    }
    else if(formapago == "03"){
        formapago = formapago + "-Transferencia electrónica de fondos";
    }
    else if(formapago == "04"){
        formapago = formapago + "-Tarjeta de crédito";
    }
    else if(formapago == "28"){
        formapago = formapago + "-Tarjeta de débito";
    }
    else if(formapago == "30"){
        formapago = formapago + "-Aplicación de anticipos";
    }
    else if(formapago == "99"){
        formapago = formapago + "-Por definir";
    }
    for (x = 0 ; x < xml.Complemento.Pagos.Pago.length; x++) {
      var pagar = parseFloat(xml.Complemento.Pagos.Pago[x].DoctoRelacionado._ImpPagado);
      pagado += pagar;
      var agregarpush = {"uuid": xml.Complemento.Pagos.Pago[x].DoctoRelacionado._IdDocumento, "serie": xml.Complemento.Pagos.Pago[x].DoctoRelacionado._Serie, "folio": xml.Complemento.Pagos.Pago[x].DoctoRelacionado._Folio,"moneda" : xml.Complemento.Pagos.Pago[x].DoctoRelacionado._MonedaDR,"cambio":xml.Complemento.Pagos.Pago[x]._TipoCambioP,"pago":"","pagado":xml.Complemento.Pagos.Pago[x].DoctoRelacionado._ImpPagado,"insoluto":xml.Complemento.Pagos.Pago[x].DoctoRelacionado._ImpSaldoInsoluto};

      rows.push(agregarpush);
    } 
  }
  
  var fecha = xml._Fecha.replace("T","/");
  fecha = fecha.split("/");
  var hora = fecha[1];
  fecha = fecha[0];
  var company_logo = {
  w: 244,
  h: 72
};
var company_logo_mini = {
  w: 61,
  h: 18
};
var comapnyJSON={
  CompanyName:'ABCD TECHONOLOGIES',
  CompanyGSTIN:'37B76C238B7E1Z5',
  CompanyState:'KERALA (09)',
  CompanyPAN:'B76C238B7E',
  CompanyAddressLine1:'ABCDEFGD HOUSE,IX/642-D',
  CompanyAddressLine2:'ABCDEFGD P.O., NEDUMBASSERY',
  CompanyAddressLine3:'COCHIN',
  PIN: '683584',
  companyEmail:'xyz@gmail.com',
  companyPhno:'+918189457845',
};

var customer_BillingInfoJSON={
  CustomerName:'Jino Shaji',
  CustomerGSTIN:'37B76C238B7E1Z5',
  CustomerState:'KERALA (09)',
  CustomerPAN:'B76C238B7E',
  CustomerAddressLine1:'ABCDEFGD HOUSE,IX/642-D',
  CustomerAddressLine2:'ABCDEFGD P.O., NEDUMBASSERY',
  CustomerAddressLine3:'COCHIN',
  PIN: '683584',
  CustomerEmail:'abcd@gmail.com',
  CustomerPhno:'+918189457845',
};


var customer_ShippingInfoJSON={
  CustomerName:'Jino Shaji',
  CustomerGSTIN:'37B76C238B7E1Z5',
  CustomerState:'KERALA (09)',
  CustomerPAN:'B76C238B7E',
  CustomerAddressLine1:'ABCDEFGD HOUSE,IX/642-D',
  CustomerAddressLine2:'ABCDEFGD P.O., NEDUMBASSERY',
  CustomerAddressLine3:'COCHIN',
  PIN: '683584',
  CustomerEmail:'abcd@gmail.com',
  CustomerPhno:'+918189457845',
};


var invoiceJSON={
  InvoiceNo:'INV-120152',
  InvoiceDate:'03-12-2017',
  RefNo:'REF-78445',
  TotalAmnt:'Rs.1,24,200',
  SubTotalAmnt:'Rs.1,04,200',
  TotalGST:'Rs.2,0000',
  TotalCGST:'Rs.1,0000',
  TotalSGST:'Rs.1,0000',
  TotalIGST:'Rs.0',
  TotalCESS:'Rs.0',
}
var imgData = img;
var fontSizes={
  HeadTitleFontSize:18,
  Head2TitleFontSize:16,
  TitleFontSize:14,
  SubTitleFontSize:12,
  NormalFontSize:10,
  SmallFontSize:8
};
var lineSpacing={
  NormalSpacing:12,
};
  var doc = new jsPDF('p', 'pt');
  var rightStartCol1=400;
  var rightStartCol2=440;
  var InitialstartX=40;
  var startX=40;
  var InitialstartY=50;
  var startY=0;
  var lineHeights=12;
  doc.setFont("helvetica");
  doc.setFontSize(8);
  doc.setTextColor(255,54,74);
  doc.text("COMPLEMENTO DE PAGO",startX, startY+=15+lineSpacing.NormalSpacing);
  doc.setTextColor(0,0,0);
  doc.setFontSize(fontSizes.SubTitleFontSize);
  doc.setFontType('bold');
  doc.addImage(imgData,'PNG',startX,startY+=lineSpacing.NormalSpacing,company_logo.w,company_logo.h);
  doc.setLineWidth(1);
  doc.rect(40,110,520,60); //Los primeros 2 Width X,Y los ultimos 2 heigth X,Y 
  doc.setTextColor(0,0,0);
   doc.text(xml.Emisor._Nombre,55, startY+=15+company_logo.h,'left');
  doc.setFontType('normal');
  doc.setFontSize(10);
  doc.text(xml.Emisor._Rfc, 55, startY+=lineSpacing.NormalSpacing);
  doc.text("General ley de personas Morales", 55, startY+=lineSpacing.NormalSpacing);
  doc.text(xml._LugarExpedicion, 55, startY+=lineSpacing.NormalSpacing);
  var tempY=InitialstartY;
  doc.setTextColor(0,0,0);
  doc.setFontType('bold');
  doc.text("Pago",rightStartCol1,60);
  doc.setFontType('bold');
  doc.text("Serie: ",  rightStartCol1, 70);
  doc.setFontType('normal');
  doc.text(serie,rightStartCol2, 70);
  doc.setFontType('bold');
  doc.text("Folio: ",rightStartCol1,80);
  doc.setFontType('normal');
  doc.text(xml._Folio, rightStartCol2, 80);
  doc.setFontType('bold');
  doc.text("Fecha: ",  rightStartCol1, 90);
  doc.setFontType('normal');
  doc.text(fecha, rightStartCol2, 90);
  doc.setFontType('bold');
  doc.text("Hora: ",  rightStartCol1, 100);
  doc.setFontType('normal');
  doc.text(hora, rightStartCol2, 100);
  doc.setFontSize(10);
  doc.setFontType('normal');
  doc.setTextColor(225,9,18);
  doc.text("Cliente:", 55,tempY+=122+lineSpacing.NormalSpacing);
  doc.setTextColor(0,0,0);
   doc.text(xml.Receptor._Nombre, 140, startY+=10+lineSpacing.NormalSpacing);
    doc.setFontType('normal');
  doc.setTextColor(225,9,18);
  doc.text("RFC:", 55,tempY+=5+lineSpacing.NormalSpacing);
  doc.setTextColor(0,0,0);
   doc.text(xml.Receptor._Rfc, 140, startY+=5+lineSpacing.NormalSpacing);
  doc.setLineWidth(1);
    doc.rect(40,210,520,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
  doc.setTextColor(0,0,0);
  doc.setFontSize(9);
  doc.setFontType('bold');
   doc.text("Detalles del pago",55, startY+=7+lineSpacing.NormalSpacing);
   doc.setTextColor(0,0,0);
   doc.setFontSize(7);
   doc.text("Banco Ordenante:", 55,tempY+=21+lineSpacing.NormalSpacing);
   doc.text("Santander", 120, startY+=2+lineSpacing.NormalSpacing);
   doc.text("Cuenta Ordenante:", 55,tempY+=4+lineSpacing.NormalSpacing);
   doc.text("014310044002563", 120, startY+=4+lineSpacing.NormalSpacing);
   doc.text("Nombre Banco Exterior:", 55,tempY+=7+lineSpacing.NormalSpacing);
   doc.text("BBVA", 140, startY+=7+lineSpacing.NormalSpacing);
   doc.text("RFC Emisor Cta Beneficiario:",200,233);
   doc.text(xml.Emisor._Rfc, 300, 233);
   doc.text("Cuenta Beneficiario:", 200,250);
   doc.text("014310044002563", 280, 250);
   doc.text("Número de operación:", 200,270);
   doc.text("43412321431", 280, 270);
   doc.text("Tipo de cambio:",360,233);
   doc.text(tipocambio, 420, 233);
   doc.text("Moneda:", 360,250);
   doc.text(monedap, 420, 250);
   doc.text("Forma de Pago:", 360,270);
   doc.text(formapago, 420, 270);
   doc.text("Fecha de Pago:",450,233);
   doc.text(fecha, 510, 233);
   doc.text("Monto:",450,250);
   console.log(pagado)
   doc.text(parseFloat(pagado).toFixed(2), 510, 250);
   doc.setLineWidth(1);
    doc.rect(40,280,520,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
  doc.setTextColor(0,0,0);
  doc.setFontSize(9);
  doc.setFontType('bold');
   doc.text("Documentos Relacionados",55, startY+=10+lineSpacing.NormalSpacing);
   doc.setTextColor(0,0,0);
   doc.setFontSize(7);

  //-------Customer Info Billing---------------------
   var startBilling=startY;
   //-------Customer Info Shipping---------------------
    var rightcol1=340;
    var rightcol2=400;
    startY=startBilling;
    var header = function(data) {
      doc.setFontSize(8);
      doc.setTextColor(40);
      doc.setFontStyle('bold');
     // doc.textAlign("TAX INVOICE", {align: "center"}, data.settings.margin.left, 50);
 
      //doc.addImage(headerImgData, 'JPEG', data.settings.margin.left, 20, 50, 50);
     // doc.text("Testing Report", 110, 50);
    };
   doc.setFontSize(8);
   doc.setFontStyle('normal');
  var options = {
      beforePageContent: header,
      margin: {
        top: 50 
      },
      styles: {
        overflow: 'linebreak',
        fontSize: 8,
        rowHeight: 'auto',
        columnWidth: 'wrap'
      },
      columnStyles: {
        1: {columnWidth: 'auto'},
        2: {columnWidth: 'auto'},
        3: {columnWidth: 'auto'},
        4: {columnWidth: 'auto'},
        5: {columnWidth: 'auto'},
        6: {columnWidth: 'auto'},
      },
      startY: startY+=10
    };
  var columns = [
      {title: "UUID", dataKey: "uuid",width: 90},
      {title: "Serie", dataKey: "serie",width: 40}, 
      {title: "Folio", dataKey: "folio",width: 40}, 
      {title: "Moneda", dataKey: "moneda",width: 40}, 
      {title: "T. Cambio", dataKey: "cambio",width: 40}, 
      {title: "M. de Pago", dataKey: "pago",width: 40}, 
      {title: "Pagado", dataKey: "pagado",width: 40}, 
      {title: "Saldo Insoluto", dataKey: "insoluto",width: 40}, 

  ];
   
  doc.autoTable(columns, rows, options);
  //-------Invoice Footer---------------------
  var rightcol1=340;
  var rightcol2=430;

  startY=doc.autoTableEndPosY()+30;
  doc.setFontSize(fontSizes.NormalFontSize);
  doc.setFillColor(225,9,18)
  doc.setLineWidth(1);
    doc.rect(40,startY+=lineSpacing.NormalSpacing,320,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
  doc.setTextColor(0,0,0);
  doc.setFontSize(9);
  doc.setFontType('bold');
   doc.text("Importe con letra",155, startY+=lineSpacing.NormalSpacing);
   doc.setTextColor(0,0,0);
   doc.setFontSize(7);

   var convertiraletras =  NumeroALetras(pagado);
  convertiraletras = convertiraletras + " M.N";
  var splitTitle = doc.splitTextToSize(convertiraletras, 300);

   doc.text(splitTitle,55, startY+=lineSpacing.NormalSpacing);
   doc.setFontSize(11);
   doc.text("Total:",410,startY-=0+lineSpacing.NormalSpacing);
   console.log(lineSpacing.NormalSpacing)
   console.log(startY)
   //startY = 431.79999999999995 - 4;
   doc.text(formato.format(parseFloat(pagado).toFixed(2)), 460, startY);
   
   const qrCodeText = `https://verificacfdi.facturaelectronica.sat.gob.mx/default.aspx?&id=${uuid}&re=${xml.Emisor._Rfc}&rr=${xml.Receptor._Rfc}&tt=000000000000000000.000000&fe=9HNHxA==`;
   const qrCodeDataURL = await generateQRCodeDataURL(qrCodeText);
   console.log(qrCodeDataURL)
   doc.addImage(qrCodeDataURL, 'png', 42, startY+=15+lineSpacing.NormalSpacing, 100, 100);
   doc.setLineWidth(3.0); 
   doc.setTextColor(0,0,0);
    doc.line(250, startY+=15, 400, startY);
    doc.setFontSize(9);
    doc.text("Firma de conformidad",275, startY+=lineSpacing.NormalSpacing);
    doc.setFillColor(225,9,18)
  doc.setLineWidth(1);
    doc.rect(250,startY+=lineSpacing.NormalSpacing,290,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
  doc.setTextColor(0,0,0);
  doc.setFontSize(9);
  doc.setFontType('bold');
   doc.text("Este documento es una representación impresa de un CFDI",270, startY+=lineSpacing.NormalSpacing);
    doc.setLineWidth(1);
    doc.rect(250,startY+=5,290,36);
   doc.setFontSize(8);
   doc.text("*Efectos fiscales al pago",270, startY+=lineSpacing.NormalSpacing);
   doc.setFontSize(9);
   doc.addImage(imgData,'PNG',370,startY+=6,company_logo_mini.w,company_logo_mini.h);
   //Primera caja
   doc.setLineWidth(1);
    doc.rect(250,startY+=12+lineSpacing.NormalSpacing,135,12);
    doc.setFontType('normal');
    doc.setFontSize(8);
   doc.text("Serie del Certificado del emisor: ",270, startY+=8);
   //primera caja derecha
   doc.setLineWidth(1);
   doc.rect(385,startY-8,155,12);
    doc.setFontType('normal');
    doc.setFontSize(8);
   doc.text(xml._NoCertificado,390, startY+1);
   //Segunda caja
    doc.setLineWidth(1);
    doc.rect(250,startY+=5,135,10);
    doc.setFontSize(8);
   doc.text("Folio Fiscal:",340, startY+=8);
   //segunda caja derecha
   doc.setLineWidth(1);
   doc.rect(385,startY-8,155,12);
    doc.setFontType('normal');
    doc.setFontSize(8);
   doc.text(uuid,390, startY+1);
   //-----------------------Segunda parte de la tabla-------------------
   //Primera caja
   doc.setLineWidth(1);
    doc.rect(250,startY+=3,135,12);
    doc.setFontType('normal');
    doc.setFontSize(8);
   doc.text("No. de serie del Certificado del SAT: ",255, startY+=8);
   //primera caja derecha
   doc.setLineWidth(1);
   doc.rect(385,startY-8,155,12);
    doc.setFontType('normal');
    doc.setFontSize(8);
   doc.text(NoCertificadoSAT,390, startY+1);
   //Segunda caja
    doc.setLineWidth(1);
    doc.rect(250,startY+=5,135,12);
    doc.setFontSize(8);
   doc.text("Fecha y hora de certificación:",280, startY+=8);
   //segunda caja derecha
   doc.setLineWidth(1);
   doc.rect(385,startY-8,155,12);
    doc.setFontType('normal');
    doc.setFontSize(8);
   doc.text(FechaTimbrado,390, startY+1);
   
   doc.setLineWidth(1);
   doc.rect(40,startY+=5+lineSpacing.NormalSpacing,520,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
    doc.text("Sello digital del CFDI",270, startY+=lineSpacing.NormalSpacing);
    doc.setFontSize(7);
    doc.rect(40,startY+=5,520,40); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
    doc.setFontSize(7);
    var splitTitleSelloCFD = doc.splitTextToSize(SelloCFD, 505)
    doc.text(splitTitleSelloCFD,45, startY+=lineSpacing.NormalSpacing);
    doc.setFontSize(8);
    doc.setLineWidth(1);
   doc.rect(40,startY+=25+lineSpacing.NormalSpacing,520,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
    doc.text("Sello del SAT",270, startY+=lineSpacing.NormalSpacing);
    doc.rect(40,startY+=5,520,40); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y
    doc.setFontSize(7);
    var splitTitleSelloSAT = doc.splitTextToSize(SelloSAT, 505);
    doc.text(splitTitleSelloSAT,45, startY+=lineSpacing.NormalSpacing);
    doc.setFontSize(8);

     doc.setFontSize(8);
    doc.setLineWidth(1);
   doc.rect(40,startY+=25+lineSpacing.NormalSpacing,520,16); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y 
    doc.text("Cadena original del complemento del certificación digital del SAT",170, startY+=lineSpacing.NormalSpacing);
    doc.rect(40,startY+=5,520,40); //Los primeros 2 Width X posicion,Y posicion los ultimos 2 altura X,Y
    doc.setFontSize(7);
    var splitTitleSelloSAT2 = doc.splitTextToSize(`||1.1| ${uuid} | ${FechaTimbrado} | ${xml.Receptor._Rfc} | ${SelloSAT}`, 505);
    doc.text(splitTitleSelloSAT2,45, startY+=lineSpacing.NormalSpacing);
    doc.setFontSize(8);


const pages = doc.internal.getNumberOfPages();
const pageWidth = doc.internal.pageSize.width;  //Optional
const pageHeight = doc.internal.pageSize.height;  //Optional
doc.setFontSize(10);  //Optional
        
for (let j = 1; j < pages + 1 ; j++) {
      let horizontalPos = pageWidth / 2;  //Can be fixed number
      let verticalPos = pageHeight - 10;  //Can be fixed number
      doc.setPage(j);
      doc.text(`Versión del comprobante: 4.0  Hoja ${j} de ${pages}`, horizontalPos, verticalPos, {align: 'center'})
  }

   //doc.text(qrcode,155, startY+=lineSpacing.NormalSpacing);
  /*doc.text("Sub Total,", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.text(invoiceJSON.SubTotalAmnt, rightcol2, startY);
  doc.setFontSize(fontSizes.NormalFontSize);
  doc.setFontType('bold');
  doc.text("CGST Rs.", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.setFontType('normal');
  doc.text(invoiceJSON.TotalCGST,rightcol2, startY);
  doc.setFontType('bold');
  doc.text("SGST Rs.", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.setFontType('normal');
  doc.text(invoiceJSON.TotalSGST,rightcol2, startY);
  doc.setFontType('bold');
  doc.text("IGST Rs.", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.setFontType('normal');
  doc.text(invoiceJSON.TotalIGST,rightcol2, startY);
  doc.setFontType('bold');
  doc.text("CESS Rs.", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.setFontType('normal');
  doc.text(invoiceJSON.TotalCESS,rightcol2, startY);
  doc.setFontType('bold');
  doc.text("Total GST Rs.", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.setFontType('normal');
  doc.text(invoiceJSON.TotalGST,rightcol2, startY);
  doc.setFontType('bold');
  doc.text("Grand Total Rs.", rightcol1, startY+=lineSpacing.NormalSpacing);
  doc.setFontType('normal');
  doc.text(invoiceJSON.TotalAmnt,rightcol2+25, startY);
  doc.setFontType('bold');
  doc.text('For '+comapnyJSON.CompanyName+',',rightcol2, startY+=lineSpacing.NormalSpacing+25);
  doc.text('Authorised Signatory',rightcol2, startY+=lineSpacing.NormalSpacing+25);*/
  doc.save('InvoiceTemplate.pdf');
}