<?php
  include_once(INCLUDES . "fundev_header.php")
?>
  <!--start main wrapper-->
  <main class="main-wrapper">
    <div class="main-content">
      <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Dasboard</div>
            <div class="ps-3">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb mb-0 p-0">
                        <li class="breadcrumb-item"><a href="javascript:;"></a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Inicio</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-auto">
                <div class="btn-group">
                    <button type="button" class="btn btn-outline-danger">Acciones</button>
                    <button type="button" class="btn btn-outline-danger split-bg-danger dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown">	<span class="visually-hidden">Toggle Dropdown</span>
                    </button>
                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-lg-end">
                        <div class="dropdown-divider"></div>	<a class="dropdown-item" href="javascript:;">Crear Orden</a>
        <div class="dropdown-divider"></div>	<a class="dropdown-item" href="javascript:;">Crear Cotización</a>
        <div class="dropdown-divider"></div>	<a class="dropdown-item" href="javascript:;">Ver ordenes</a>
                    </div>
                </div>
            </div>
        </div>
        <!--end breadcrumb-->
          <!--inicio borrado-->
          <div class="col-lg-12 col-xxl-12 d-flex align-items-stretch">
            <div class="card w-100 rounded-4">
              <div class="card-body" id="dasboard-card-body">
                <div class="d-flex align-items-start justify-content-between mb-3">
                  <div class=""><h5 class="mb-0">Datos Ventas</h5></div>
                  <div class="dropdown">
                    <a href="javascript:;" class="dropdown-toggle-nocaret options dropdown-toggle" data-bs-toggle="dropdown">
                      <span class="material-icons-outlined fs-5">more_vert</span>
                    </a>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                    </ul>
                  </div>
                </div>
                <!-- El JS insertará aquí todo el reporte -->
              </div>
            </div>
          </div>
          <!-- ===== XTINFIRE PRO LOADER ===== -->
<div id="xtf-loader" class="xtf-loader d-none">
    <div class="xtf-loader-content">
        <div class="xtf-ring"></div>

        <div class="xtf-logo">XTINFIRE</div>

        <div class="xtf-loading-text" id="xtf-loading-text">
            Procesando datos…
        </div>
    </div>
</div>

          <div class="card rounded-4 mb-4">
  <div class="card-body">
    <div class="row g-3">

      <!-- Filtro por vendedor -->
      <div class="col-12 col-md-4">
        <label class="form-label">Vendedor</label>
        <select id="filtroVendedor" class="form-select">
          <option value="">Todos</option>
        </select>
      </div>

      <!-- Filtro por tipo -->
      <div class="col-12 col-md-4">
        <label class="form-label">Tipo de Orden</label>
        <select id="filtroTipo" class="form-select">
          <option value="">Todos</option>
          <option value="1">Equipo Nuevo</option>
          <option value="2">Recarga y Mantenimiento</option>
          <option value="3">Capacitaciones</option>
          <option value="6">PIPC</option>
          <option value="7">Proyectos Especiales</option>
        </select>
      </div>

      <!-- Filtro por periodo -->
      <div class="col-12 col-md-4">
        <label class="form-label">Periodo</label>
        <select id="filtroPeriodo" class="form-select">
          <option value="3m">Últimos 3 meses</option>
          <option value="6m">Últimos 6 meses</option>
          <option value="12m" selected>Últimos 12 meses</option>
          <option value="ytd">Año actual</option>
          <option value="trimestre">Trimestre actual</option>
          <option value="custom">Rango personalizado</option>
        </select>
      </div>

      <!-- Rango personalizado -->
      <div class="col-6 col-md-3 d-none" id="divInicio">
        <label class="form-label">Fecha inicio</label>
        <input type="date" id="filtroFechaInicio" class="form-control">
      </div>
      <div class="col-6 col-md-3 d-none" id="divFin">
        <label class="form-label">Fecha fin</label>
        <input type="date" id="filtroFechaFin" class="form-control">
      </div>

      <!-- Botón aplicar -->
      <div class="col-12 col-md-3 align-self-end">
        <button id="btnAplicarFiltros" class="btn btn-danger w-100">
          Aplicar filtros
        </button>
      </div>

    </div>
  </div>
</div>

          <div class="col-lg-12 col-xxl-12 d-flex align-items-stretch">
          <div class="card w-100 rounded-4 mt-4">
            <h5 class="py-3 px-4">Resumen gráfico (últimos 3 meses)</h5>
          <div class="card-body" id="dashboard-graficos">
              
              <!-- Aquí se inyectará TODO vía JS -->
          </div>
          <div class="card w-100 rounded-4 mt-4">
          <div class="card-body" >
              <h5 class="mb-2">Tendencia Mensual – <span class="textper">Últimos 12 meses</span></h5>
                <canvas id="chartTendenciaMensual" height="110"></canvas>
          </div>
      </div>
        <div class="card w-100 rounded-4 mt-4">
    <div class="card-body">
        <h5 class="mb-3">Distribución por Tipo de Orden – <span class="textper">Últimos 12 meses</span></h5>
        <canvas id="chartDonutTipo" height="130"></canvas>
    </div>
</div>
<div class="card w-100 rounded-4 mt-4">
    <div class="card-body">
        <h5 class="mb-3">Ventas por Tipo de Orden — <span class="textper">Últimos 12 meses</span></h5>
          <canvas id="chartStacked" height="130"></canvas>
    </div>
</div>
<div class="card w-100 rounded-4 mt-4">
    <div class="card-body">
        <h5 class="mb-3">Ranking de Vendedores — <span class="textper">Últimos 12 meses</span></h5>

        <!-- Podium (top 3) -->
        <div id="ranking-podium" class="row mb-4"></div>

        <!-- Tabla del ranking completo -->
        <div class="table-responsive">
            <table class="table table-striped align-middle" id="tablaRanking">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Vendedor</th>
                        <th>Total Órdenes</th>
                        <th>Total Dinero</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>

    </div>
</div>
<div class="card mt-4">
    <div class="card-body">
        <h5 class="mb-3">Ranking por Ventas (Gráfico)</h5>
        <canvas id="chartRanking"></canvas>
    </div>
</div>



        </div>
        </div>
          <!--Fin card-->
        </div>
    </div>
  </main>
  <!--end main wrapper-->

  <!--start overlay-->
     <div class="overlay btn-toggle"></div>
  <!--end overlay-->

   <!--start footer-->
   <footer class="page-footer">
    <p class="mb-0">Copyright © 2025. Todos los derechos reservados FUNDEVSTUDIO.</p>
  </footer>
  <!--end footer-->

<?php include_once(INCLUDES . "modalordenactivas.php")?>
<!-- Modal -->
<?php include_once(INCLUDES . "modalfoto.php")?>
<?php include_once(INCLUDES . "cambiartema.php")?>
<?php include_once(INCLUDES . "footerGeneral.php")?>
<script src="<?php echo JS . 'graficos/animacion-loader.js?ver=1.0.3'; ?>"></script>
<script src="<?php echo JS . 'graficos/dashboardv3.js?ver=1.0.8'; ?>"></script>
<script src="<?php echo JS . 'graficos/chart-manager.js?ver=1.0.1'; ?>"></script>
<script src="<?php echo JS . 'graficos/filtros-avanzados.js?ver=1.0.3';?>"></script>
<script src="<?php echo JS . 'graficos/dashboard-graficos.js?ver=1.1.1';?>"></script>
<script src="<?php echo JS . 'graficos/dashboard-tendencia.js?ver=1.1.2';?>"></script>
<script src="<?php echo JS . 'graficos/dashboard-donut.js?ver=1.1.2';?>"></script>
<script src="<?php echo JS . 'graficos/dashboard-stacked.js?ver=1.1.2';?>"></script>
<script src="<?php echo JS . 'graficos/dashboard-ranking.js?ver=1.1.2';?>"></script>

</body>
</html>