<?php
include INCLUDES . "inc_header.php";
include INCLUDES . "nav-izq.php";
include INCLUDES . "nav-menu.php";
?>
<div class="container py-5"> 
<div class="container py-5">
  <div class="mb-4">
    <h1 class="h3 mb-1">Generador de Reportes</h1>
    <input type="hidden" id="tipoval" value="<?php echo $_SESSION['usuario']['tipousoval'];?>">
    <p class="text-secondary mb-0">
      Este formulario envía <span class="badge text-bg-dark">POST</span> a endpoints dinámicos en
      <code>./pdfreportes/...</code> para que tu PHP con TCPDF genere el PDF.
    </p>
  </div>
</div>
  <form id="formReportes" method="POST" action="./pdfreportes/pdfcatalogo" target="_blank" novalidate>
    <!-- Configuración básica -->
    <div class="card mb-3">
      <div class="card-header fw-semibold">Configuración básica</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-12 col-md-4">
            <label for="selDepto" class="form-label">Departamento</label>
            <select id="selDepto" name="departamento" class="form-select" required>
              <option value="" selected disabled>— Selecciona —</option>
              <option>Almacen</option>
              <option>Ventas</option>
              <option>PIPC</option>
              <option>Capacitaciones</option>
              <option>Reparto</option>
              <option>Movimientos por usuario</option>
              <option>Tienda</option>
            </select>
            <div class="form-text">El tipo de reporte depende del departamento.</div>
            <div class="invalid-feedback">Selecciona un departamento.</div>
          </div>

          <div class="col-12 col-md-5">
            <label for="selReporte" class="form-label">Tipo de reporte</label>
            <select id="selReporte" name="reporte" class="form-select" required disabled>
              <option value="" selected disabled>— Selecciona un departamento primero —</option>
            </select>
            <div class="small mt-2">
              <span class="text-secondary">Action actual:</span>
              <code id="actionPreview" class="action-preview">./pdfreportes/pdfcatalogo</code>
            </div>
            <div class="invalid-feedback">Selecciona un tipo de reporte.</div>
          </div>

          <div class="col-12 col-md-3">
            <label class="form-label">Vista</label>
            <div class="d-flex gap-2">
              <input type="radio" class="btn-check" name="vista" id="vistaLista" value="lista" autocomplete="off" checked>
              <label class="btn btn-outline-dark w-100" for="vistaLista">Lista</label>

              <input type="radio" class="btn-check" name="vista" id="vistaCuadros" value="cuadros" autocomplete="off">
              <label class="btn btn-outline-dark w-100" for="vistaCuadros">A cuadros</label>
            </div>
            <div class="form-text">Se envía como <code>vista=lista|cuadros</code>.</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Rango de fechas -->
    <div class="card mb-3">
      <div class="card-header fw-semibold">Rango de fechas</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-12 col-md-6">
            <label for="fechaIni" class="form-label">Fecha inicial</label>
            <input type="date" id="fechaIni" name="fecha_inicial" value="<?php echo date("Y-m-d");?>" class="form-control" required>
            <div class="invalid-feedback">Elige la fecha inicial.</div>
          </div>
          <div class="col-12 col-md-6">
            <label for="fechaFin" class="form-label">Fecha final</label>
            <input type="date" id="fechaFin" name="fecha_final" value="<?php echo date("Y-m-d");?>" class="form-control" required>
            <div class="invalid-feedback">Elige la fecha final.</div>
          </div>
        </div>
        <div class="alert alert-warning mt-3 py-2 px-3 d-none" id="alertFechas">
          La fecha final no puede ser menor que la fecha inicial.
        </div>
        <!-- CAP: Buscar por fecha de agenda (solo para Desglose de Capacitaciones) -->
        <div id="capFechaAgendaWrap" class="form-check mt-3 d-none">
          <input class="form-check-input" type="checkbox"
                id="capFechaAgenda" name="cap_fecha_agenda" value="1" disabled>
          <label class="form-check-label" for="capFechaAgenda">
            Buscar por fecha agenda
          </label>
          <div class="form-text">
            Usa evntFechaInicio/Fin del calendario en lugar de la fecha de la orden.
          </div>
        </div>

      </div>
    </div>

    <!-- Categorías -->
    <div id="categoriasCard" class="card mb-3">
      <div class="card-header fw-semibold">Categorías a incluir</div>
      <div class="card-body">
        <div class="col-12">
            <div id="categoriasWrap" class="chips d-flex flex-wrap gap-2-reporte"></div>
        </div>
        <div class="form-text">Se enviarán como múltiples <code>categorias[]</code> (value = <em>catId</em>).</div>
        <div id="categoriasNotice" class="small text-secondary mt-2"></div>
      </div>
    </div>

    <!-- Opciones avanzadas (generales + extras) -->
    <div id="advCard" class="card mb-3">
      <div class="card-header fw-semibold">Opciones avanzadas</div>
      <div class="card-body">
        <p id="avisoOpciones" class="text-secondary mb-3">Activa o desactiva detalles a incluir en el PDF.</p>

        <!-- Contenedor SOLO de los checks (se puede ocultar para Capacitaciones) -->
        <div id="optsAvanzadas" class="row g-3"></div>

        <!-- Extras dentro de Opciones Avanzadas: VENTAS → Ventas por Producto -->
        <div id="advExtrasVPP" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="vppSku" class="form-label">SKU del producto</label>
            <input type="text" class="form-control" id="vppSku" name="vpp_sku" placeholder="Ej. ABC-12345" autocomplete="off">
            <div class="form-text">Opcional: filtra por SKU exacto.</div>
          </div>
          <div class="col-12 col-md-6">
            <label for="vppAlmacen" class="form-label">Almacén</label>
            <select class="form-select" id="vppAlmacen" name="vpp_almacen_id" disabled>
              <option value="">Cargando almacenes…</option>
            </select>
            <div class="form-text" id="vppAlmacenHelp">Selecciona el almacén donde buscar el producto.</div>
          </div>
          <div class="col-12 col-md-6" id="vppUltimaWrap">
            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" id="vppUltima" name="vpp_ultima" value="1">
              <label class="form-check-label" for="vppUltima">Mostrar la última venta</label>
            </div>
          </div>
        </div>

        <!-- Extras dentro de Opciones Avanzadas: PIPC -->
        <div id="advExtrasPIPC" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="piporigen" name="pipc_origen" value="1">
              <label class="form-check-label" for="piporigen">Desde el origen de los tiempos</label>
            </div>
          </div>
          <div class="col-12 col-md-6">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="pipcCaducar" name="pipc_caducar" value="1">
              <label class="form-check-label" for="pipcCaducar">Órdenes por caducar o caducadas</label>
            </div>
          </div>
          <div class="col-12 col-md-6">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="pipcActivas" name="pipc_activas" value="1">
              <label class="form-check-label" for="pipcActivas">Órdenes activas</label>
            </div>
          </div>
          <div class="col-12 col-md-6">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="pipcNoPagadas" name="pipc_no_pagadas" value="1">
              <label class="form-check-label" for="pipcNoPagadas">Órdenes no pagadas</label>
            </div>
          </div>
          <div class="col-12 col-md-6">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="pipcPagadasSinRevisar" name="pipc_pagadas_sin_revisar" value="1">
              <label class="form-check-label" for="pipcPagadasSinRevisar">Órdenes pagadas sin revisar</label>
            </div>
          </div>
          <div class="col-12 col-md-6">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="pipcTodas" name="pipc_todas" value="1">
              <label class="form-check-label" for="pipcTodas">Todas las órdenes</label>
            </div>
          </div>
          <p>* <code>Si hay un tipo de estatus que no este dentro de la busqueda puede ocasionar un reporte vacio solo quita ese check e intenta con otros filtros puedes jugar con ellos para obtener el mismo resultado que necesitas.</code></p>
        </div>

        <!-- NUEVO: REPARTO → Tipo de reporte (checkboxes) -->
        <div id="advExtrasREP" class="row g-3 mt-1 d-none">
          <div class="col-12">
            <h6 class="mb-2">Reparto – Tipo de reporte</h6>
            <div class="text-secondary small">Selecciona <strong>uno</strong>. Se envía como flags en el POST.</div>
          </div>

          <div class="col-12 col-md-4">
            <div class="form-check">
              <input class="form-check-input rep-flag" type="checkbox" id="repPendientes" name="rep_pendientes" value="1">
              <label class="form-check-label" for="repPendientes">Pendientes por asignar</label>
            </div>
          </div>

          <div class="col-12 col-md-4">
            <div class="form-check">
              <input class="form-check-input rep-flag" type="checkbox" id="repAsignadas" name="rep_asignadas" value="1">
              <label class="form-check-label" for="repAsignadas">Asignadas</label>
            </div>
          </div>

          <div class="col-12 col-md-4">
            <div class="form-check">
              <input class="form-check-input rep-flag" type="checkbox" id="repAsignadasRep" name="rep_asignadas_por_repartidor" value="1">
              <label class="form-check-label" for="repAsignadasRep">Asignadas por repartidor</label>
            </div>
          </div>

          <div class="col-12 col-md-4">
            <div class="form-check">
              <input class="form-check-input rep-flag" type="checkbox" id="repDevueltos" name="rep_devueltos" value="1">
              <label class="form-check-label" for="repDevueltos">Devueltos Almacén</label>
            </div>
          </div>

          <div class="col-12 col-md-4">
            <div class="form-check">
              <input class="form-check-input rep-flag" type="checkbox" id="repEntregadas" name="rep_entregadas" value="1">
              <label class="form-check-label" for="repEntregadas">Entregadas</label>
            </div>
          </div>
        </div>

       <!-- Extras dentro de Opciones Avanzadas: ALMACÉN → Traspasos -->
        <div id="advExtrasTR" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="traspAlmacen" class="form-label">Almacén (Traspasos)</label>
            <select class="form-select" id="traspAlmacen" name="trasp_almacen_id" disabled>
              <option value="">Cargando almacenes…</option>
            </select>
            <div class="form-text" id="traspAlmacenHelp">Selecciona el almacén para el reporte de traspasos.</div>
          </div>

          <!-- NUEVO: Filtro por SKU o Nombre de producto -->
          <div class="col-12 col-md-6">
            <label for="traspFiltro" class="form-label">Producto (SKU o nombre)</label>
            <input type="text" class="form-control" id="traspFiltro" name="trasp_filtro"
                  placeholder="SKU exacto o nombre que contenga…">
            <div class="form-text">
              Filtra por <code>historialproSku</code> (SKU) o por <code>proTitulo</code> (contiene).
            </div>
          </div>
        </div>

        <!-- NUEVO: ALMACÉN → Inventarios -->
        <div id="advExtrasALM_INV" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="invAlmacen" class="form-label">Almacén (Inventarios)</label>
            <select class="form-select" id="invAlmacen" name="inv_almacen_id" disabled>
              <option value="">Cargando almacenes…</option>
            </select>
            <div class="form-text" id="invAlmacenHelp">Selecciona el almacén para el reporte de inventarios.</div>
          </div>
        </div>

        <!-- Extras dentro de Opciones Avanzadas: VENTAS → Ventas por vendedores -->
        <div id="advExtrasVV" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="vvVendedor" class="form-label">Vendedor</label>
            <select class="form-select" id="vvVendedor" name="vv_vendedor_id" disabled>
              <option value="">Cargando vendedores…</option>
            </select>
            <div class="form-text" id="vvVendedorHelp">Selecciona el vendedor para filtrar el reporte.</div>
          </div>
        </div>

        <!-- Extras dentro de Opciones Avanzadas: VENTAS → Filtros comunes (Estatus / Transito) -->
        <div id="advExtrasVENTAS_FILTROS" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="venEstatus" class="form-label">Estatus de la orden</label>
            <select class="form-select" id="venEstatus" name="ven_estatus_id" disabled>
              <option value="">— Todos —</option>
            </select>
            <div class="form-text">Filtra por estatus de la orden.</div>
          </div>
          <div class="col-12 col-md-6">
            <label for="venTransito" class="form-label">Departamento en tránsito</label>
            <select class="form-select" id="venTransito" name="ven_transito_id" disabled>
              <option value="">— Todos —</option>
            </select>
            <div class="form-text">Filtra por el departamento en tránsito.</div>
          </div>
        </div>

        <!-- Extras dentro de Opciones Avanzadas: CAPACITACIONES → Instructor/Encargado (SOLO en Desglose) -->
        <div id="advExtrasCAP" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="capInstructor" class="form-label">Instructor / Encargado</label>
            <select class="form-select" id="capInstructor" name="cap_instructor_id" disabled>
              <option value="">Cargando encargados…</option>
            </select>
            <div class="form-text" id="capInstructorHelp">Selecciona el encargado de capacitación.</div>
          </div>
        </div>

        <!-- NUEVO: CAPACITACIONES → Filtros (visibles cuando el departamento es Capacitaciones) -->
        <div id="advExtrasCAP_FILTROS" class="row g-3 mt-1 d-none">
          <div class="col-12">
            <h6 class="mb-2">Filtros de Capacitaciones</h6>
          </div>

          <!-- Por cliente (checkbox + input condicional) -->
          <div class="col-12 col-md-4">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="capPorCliente" name="cap_por_cliente" value="1">
              <label class="form-check-label" for="capPorCliente">Por cliente</label>
            </div>
            <div class="form-text">Activar para buscar por cliente.</div>
          </div>
          <div class="col-12 col-md-8 d-none" id="capClienteWrap">
            <label for="capCliente" class="form-label">Cliente</label>
            <input type="text" class="form-control" id="capCliente" name="cap_cliente_query" placeholder="Ingresa nombre o ID del cliente">
            <div class="form-text">Escribe el <strong>nombre</strong> o el <strong>ID</strong> del cliente para filtrar las capacitaciones.</div>
          </div>

          <!-- Estatus (checks) -->
          <div class="col-12 col-md-2">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="capRealizados" name="cap_realizados" value="1">
              <label class="form-check-label" for="capRealizados">Realizados</label>
            </div>
          </div>
          <div class="col-12 col-md-2">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="capPendientes" name="cap_pendientes" value="1">
              <label class="form-check-label" for="capPendientes">Pendientes</label>
            </div>
          </div>
          <div class="col-12 col-md-2">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="capSinRevisar" name="cap_sin_revisar" value="1">
              <label class="form-check-label" for="capSinRevisar">Sin Revisar</label>
            </div>
          </div>
          <div class="col-12 col-md-2">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="capPospuestos" name="cap_pospuestos" value="1">
              <label class="form-check-label" for="capPospuestos">Pospuestos</label>
            </div>
          </div>
          <div class="col-12 col-md-2">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="capPagados" name="cap_pagados" value="1">
              <label class="form-check-label" for="capPagados">Pagados</label>
            </div>
          </div>
        </div>

        <!-- NUEVO: CAPACITACIONES → Asistencia: campo Orden (solo visible en Asistencia) -->
        <div id="advExtrasCAP_ASIST" class="row g-3 mt-1 d-none">
          <div class="col-12 col-md-6">
            <label for="capOrden" class="form-label">Orden</label>
            <input type="text" class="form-control" id="capOrden" name="cap_orden" placeholder="Ingresa la orden a buscar">
            <div class="form-text">Escribe el número de orden para el reporte de asistencias.</div>
          </div>
        </div>

        <!-- MOVIMIENTOS POR USUARIO → Por usuario / Por departamento / Por acción -->
        <div id="advExtrasMOV" class="row g-3 mt-1 d-none">
          <!-- Por usuario -->
          <div id="movPorUsuarioWrap" class="col-12 col-md-6 d-none">
            <label for="movUsuario" class="form-label">Usuario</label>
            <select class="form-select" id="movUsuario" name="mov_usuario_id" disabled>
              <option value="">Cargando usuarios…</option>
            </select>
            <div class="form-text" id="movUsuarioHelp">Selecciona el usuario para el reporte.</div>
          </div>
          <!-- Por departamento -->
          <div id="movPorDeptoWrap" class="col-12 col-md-6 d-none">
            <label for="movDepto" class="form-label">Departamento</label>
            <select class="form-select" id="movDepto" name="mov_depto_id" disabled>
              <option value="">Cargando departamentos…</option>
            </select>
            <div class="form-text" id="movDeptoHelp">Selecciona el departamento para el reporte.</div>
          </div>
          <!-- Por acción -->
          <div id="movPorAccionWrap" class="col-12 col-md-6 d-none">
            <label for="movAccion" class="form-label">Acción</label>
            <select class="form-select" id="movAccion" name="mov_accion" disabled>
              <option value="">Selecciona una acción…</option>
            </select>
            <div class="form-text">Filtra por la acción realizada.</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Filtros específicos: Almacén → Compras -->
    <div id="comprasExtrasCard" class="card mb-3 d-none">
      <div class="card-header fw-semibold">Filtros de Compras (Almacén)</div>
      <div class="card-body">
        <div class="row g-3">
          <div class="col-12 col-md-4">
            <label for="compSku" class="form-label">SKU del producto</label>
            <input type="text" class="form-control" id="compSku" name="comp_sku" placeholder="Ej. ABC-12345">
            <div class="form-text">Opcional: filtra por un producto específico.</div>
          </div>
          <div class="col-12 col-md-4">
            <label for="compEstado" class="form-label">Estatus</label>
            <select class="form-select" id="compEstado" name="comp_estado">
              <option value="">— Todas —</option>
              <option value="activa">Activa</option>
              <option value="pendiente_cotizar">Pendiente por cotizar</option>
              <option value="completada">Completada</option>
            </select>
          </div>
          <div class="col-12 col-md-4 d-flex align-items-end gap-3 flex-wrap">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="compUltimo" name="comp_ultimo" value="1">
              <label class="form-check-label" for="compUltimo">Buscar último registro</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="compDetallado" name="comp_detallado" value="1">
              <label class="form-check-label" for="compDetallado">Reporte con detalles</label>
            </div>
          </div>
        </div>

        <hr class="my-4">
        <h6 class="mb-3">Detalles opcionales</h6>
        <div class="row g-3">
          <div class="col-12 col-md-4">
            <label for="compProveedor" class="form-label">Proveedor</label>
            <input type="text" class="form-control" id="compProveedor" name="comp_proveedor" placeholder="Nombre o RUC/RFC">
          </div>
          <div class="col-12 col-md-4">
            <label for="compOrden" class="form-label"># Orden / Folio</label>
            <input type="text" class="form-control" id="compOrden" name="comp_orden" placeholder="OC-000123">
          </div>
          <div class="col-12 col-md-4">
            <label for="compPago" class="form-label">Forma de pago</label>
            <select class="form-select" id="compPago" name="comp_pago">
              <option value="">— Todas —</option>
              <option value="contado">Contado</option>
              <option value="credito">Crédito</option>
              <option value="mixta">Mixta</option>
            </select>
          </div>
          <div class="col-12 col-md-4">
            <label for="compMoneda" class="form-label">Moneda</label>
            <select class="form-select" id="compMoneda" name="comp_moneda">
              <option value="">— Todas —</option>
              <option value="MXN">MXN</option>
              <option value="USD">USD</option>
              <option value="PEN">PEN</option>
            </select>
          </div>
          <div class="col-12 col-md-4">
            <label for="compMontoMin" class="form-label">Monto mínimo</label>
            <input type="number" step="0.01" class="form-control" id="compMontoMin" name="comp_monto_min" placeholder="0.00">
          </div>
          <div class="col-12 col-md-4">
            <label for="compMontoMax" class="form-label">Monto máximo</label>
            <input type="number" step="0.01" class="form-control" id="compMontoMax" name="comp_monto_max" placeholder="0.00">
          </div>
          <div class="col-12 col-md-4 d-flex align-items-end gap-3 flex-wrap">
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="compIncluirCanceladas" name="comp_incluir_canceladas" value="1">
              <label class="form-check-label" for="compIncluirCanceladas">Incluir canceladas</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="checkbox" id="compIncluirDevoluciones" name="comp_incluir_devoluciones" value="1">
              <label class="form-check-label" for="compIncluirDevoluciones">Incluir devoluciones</label>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Submit -->
    <div class="d-flex align-items-center gap-3">
      <button type="submit" class="btn btn-dark">Generar PDF</button>
      <span class="text-secondary">El PDF se abrirá en una nueva pestaña.</span>
    </div>

    <input type="hidden" name="ui_version" value="v10-bootstrap5">
  </form>
</div>


    <?php
    include INCLUDES . "footerOrdenes.php";
    ?>
<script src="<?php echo JS; ?>reports/reportes_v2.js?ver=1.0.40"></script>
</body>
</html>
